package com.liquidnet.service.adam.controller.web.sys;

import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.entity.AdamSysCountryProvince;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.service.IAdamSysCountryProvinceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 国家州/省 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-22
 */
@Api(tags = "web sys country-province")
@RestController
@RequestMapping("/adam-sys-country-province")
public class AdamSysCountryProvinceController {
    @Autowired
    private IAdamSysCountryProvinceService sysCountryProvinceService;

    @NoAuth
    @ApiOperation(value = "国家州省")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_SYS)
    @ApiImplicitParams({
            @ApiImplicitParam(paramType = "query", dataType = "String", name = "countryCode", value = "国家代码")
    })
    @GetMapping("/list_province")
    public ResponseDto<List<AdamSysCountryProvince>> listProvince(@RequestParam String countryCode) {

        // 国家/地区代码,电话代码
        List<AdamSysCountryProvince> sysCountryProvinces = sysCountryProvinceService.selectList(countryCode);
        return ResponseDto.success(sysCountryProvinces);
    }

}
