package com.liquidnet.service.adam.controller.web.sys;

import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;

import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.service.sys.IAdamSysMongoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Slf4j
@Api(tags = "web sys MongoDB")
@RestController
@RequestMapping("/adam-sys-mongo")
public class AdamSysMongoController {

    @Autowired
    private IAdamSysMongoService iAdamSysMongoService;

    @NoAuth
    @ApiOperation(value = "上传文件")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_SYS)
    @ApiImplicitParams({@ApiImplicitParam(name = "file", value = "文件流对象", required = true, dataType = "__File")})
    @PostMapping(value = "/upload")
    public ResponseDto<String> upload(@RequestParam("file") MultipartFile videoFile) {
        log.info("文件上传开始，文件名：" + videoFile.getOriginalFilename() + "，大小:" + (videoFile.getSize() / 1024) + "kb");
        if (videoFile.getSize() / 1024 / 1024 > 10) {
            log.warn("文件上传大于10M");
            return ResponseDto.failure("100000", "文件最大上传10M");
        }
        String newFileName = null;
        try {
            newFileName = iAdamSysMongoService.uploadFile(videoFile.getBytes(), videoFile.getOriginalFilename());
        } catch (Exception e) {
            log.error("文件上传出错", e);
            return ResponseDto.failure("100001", "文件上传错误");
        }
        log.info("文件mongoo上传返回：" + newFileName);
        if (StringUtils.isNotBlank(newFileName)) {
            return ResponseDto.success(newFileName);
        }
        log.warn("文件上传失败");
        return ResponseDto.failure("100002", "文件上传失败，请重试");
    }

}
