package com.liquidnet.service.adam.controller.web.user;

import com.alibaba.fastjson.JSON;
import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.common.AdamErrorCode;
import com.liquidnet.service.adam.dto.base.AdamCurrentUser;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.service.IAdamUserService;
import com.liquidnet.service.adam.util.CurrentUserUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-16
 */
@Slf4j
@Api(tags = "web user")
@RestController
@RequestMapping("/adam-user")
public class AdamUserController {

    @Autowired
    private IAdamUserService adamUserService;

    @ApiOperation(value = "get user info")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_0)
    @ApiImplicitParams({
            @ApiImplicitParam(type = "header", dataType = "String", name = "token", value = "token")
    })
    @GetMapping("/get_current_user")
    public ResponseDto<AdamCurrentUser> getCurrentUser(HttpServletRequest request) {
        AdamCurrentUser currentUser = CurrentUserUtil.getCurrentUser(request);
        return ResponseDto.success(currentUser);
    }

    @NoAuth
    @ApiOperation(value = "bind phone number and send sms confirm code")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_0)
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "email", value = "邮箱"),
            @ApiImplicitParam(type = "form", dataType = "String", name = "phoneCode", value = "电话代码"),
            @ApiImplicitParam(type = "form", dataType = "String", name = "phoneNumber", value = "电话号码")
    })
    @PostMapping("/bind_phone")
    public ResponseDto bindPhone(@RequestParam String email, @RequestParam String phoneCode ,@RequestParam String phoneNumber) {


        if (Strings.isEmpty(email) || Strings.isEmpty(phoneCode) || Strings.isEmpty(phoneNumber)) {
            return ResponseDto.failure(AdamErrorCode.ILLEGAL_PARAM.getCode(), AdamErrorCode.ILLEGAL_PARAM.getVal());
        }
        AdamResultDto<Object> dto = adamUserService.bindUserPhoneAndSendSMSCode(email, phoneCode,phoneNumber);
        return AdamResultDto.getResponseDto(dto);
    }



}
