package com.liquidnet.service.adam.controller.web.user;
import com.alibaba.fastjson.JSON;
import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.constant.AdamUserFeedbackConstants;
import com.liquidnet.service.adam.dto.AdamUserFeedbackParam;
import com.liquidnet.service.adam.dto.base.AdamCurrentUser;
import com.liquidnet.service.adam.entity.AdamUserFeedback;
import com.liquidnet.service.adam.incrementer.CustomIdGenerator;
import com.liquidnet.service.adam.interceptor.annotation.NoAuth;
import com.liquidnet.service.adam.service.IAdamUserFeedbackService;
import com.liquidnet.service.adam.util.CurrentUserUtil;
import com.liquidnet.service.adam.util.EnumUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 用户反馈 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2020-11-19
 */

@Api(tags = "web user feedback")
@Slf4j
@RestController
@RequestMapping("/adam-user-feedback")
public class AdamUserFeedbackController {

    @Autowired
    private IAdamUserFeedbackService adamUserFeedbackService;

    @Autowired
    private CustomIdGenerator customIdGenerator;

    @NoAuth
    @ApiOperation(value = "enum list")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_2)
    @GetMapping("/enum_list")
    public ResponseDto<List<Map<String, String>>> enumList() {
        List<Map<String, String>> list = EnumUtil.getList(AdamUserFeedbackConstants.CategoryEnum.values());
        return ResponseDto.success(list);
    }

    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_2)
    @ApiOperation(value = "submit")
    @PostMapping(value = "/submit")
    public ResponseDto submit(@ModelAttribute AdamUserFeedbackParam param,
                              HttpServletRequest request) {
        AdamCurrentUser currentUser = CurrentUserUtil.getCurrentUser(request);
        String comId = currentUser.getComId();
        String userId = currentUser.getId();
        String logFx = "submit user feedback.userId=[" + userId + "]";
        try {
            AdamUserFeedback adamUserFeedback = new AdamUserFeedback();
            adamUserFeedback.setId(String.valueOf(customIdGenerator.nextId(adamUserFeedback)));
            adamUserFeedback.setComId(comId);
            adamUserFeedback.setUserId(userId);
            adamUserFeedback.setCategory(param.getCategory());
            adamUserFeedback.setDetail(param.getDetail());
            adamUserFeedback.setFiles(JSON.toJSONString(param.getFiles()));
            int insret = adamUserFeedbackService.insert(adamUserFeedback);
            return ResponseDto.success();
        } catch (Exception e) {
            log.error(logFx + "error", e);
            return ResponseDto.failure(ErrorCode.HTTP_SYSTEM_ERROR);
        }
    }

}
