package com.liquidnet.service.adam.controller.web.user;

import com.liquidnet.common.swagger.config.SwaggerApiVersion;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.biz.AdamUserLoginBiz;
import com.liquidnet.service.adam.config.swagger.AdamSwaggerApiVersionConstant;
import com.liquidnet.service.adam.dto.base.AdamCurrentUser;
import com.liquidnet.service.adam.util.CurrentUserUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

@Slf4j
@Api(tags = "web user login out")
@RestController
@RequestMapping("/adam-user-login-out")
public class AdamUserLoginOutController {
    @Autowired
    private AdamUserLoginBiz adamUserLoginBiz;

    @ApiOperation(value = "user login out")
    @SwaggerApiVersion(group = AdamSwaggerApiVersionConstant.WEB_1_0)
    @ApiImplicitParams({
    })
    @PostMapping("/login-out")
    public ResponseDto userLogOut(HttpServletRequest request) {
        return ResponseDto.success();
    }
}
