package com.liquidnet.service.adam.service.admin.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.adam.constant.AdamTransactionConstants;
import com.liquidnet.service.adam.dto.AdamTransactionDto;
import com.liquidnet.service.adam.dto.admin.transaction.AdamConversionRecordReq;
import com.liquidnet.service.adam.dto.admin.transaction.AdamPayoutDetailDto;
import com.liquidnet.service.adam.dto.admin.transaction.AdamPayoutRecordReq;
import com.liquidnet.service.adam.dto.admin.transaction.AdamRechargeRecordReq;
import com.liquidnet.service.adam.entity.AdamPayout;
import com.liquidnet.service.adam.entity.AdamPayoutBeneficiary;
import com.liquidnet.service.adam.entity.AdamPayoutPayer;
import com.liquidnet.service.adam.entity.AdamTransaction;
import com.liquidnet.service.adam.mapper.AdamPayoutBeneficiaryMapper;
import com.liquidnet.service.adam.mapper.AdamPayoutMapper;
import com.liquidnet.service.adam.mapper.AdamPayoutPayerMapper;
import com.liquidnet.service.adam.mapper.AdamTransactionMapper;
import com.liquidnet.service.adam.service.admin.transaction.IAdminTransactionRecordService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 交易信息记录表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-20
 */
@Service("adminTransactionRecordService")
public class AdminTransactionRecordServiceImpl implements IAdminTransactionRecordService {


    @Autowired
    private AdamTransactionMapper adamTransactionMapper;

    @Autowired
    private AdamPayoutMapper adamPayoutMapper;

    @Autowired
    private AdamPayoutPayerMapper adamPayoutPayerMapper;

    @Autowired
    private AdamPayoutBeneficiaryMapper adamPayoutBeneficiaryMapper;

    /**
     * 充值列表查询
     * @param pageNum
     * @param pageSize
     * @param queryParam
     * @param comId
     * @return
     */
    @Override
    public Page<AdamTransactionDto> queryRechargePageList(int pageNum, int pageSize, AdamRechargeRecordReq queryParam, String comId) {
        //拼装查询条件
        LambdaQueryWrapper<AdamTransaction> wrapper = this.transferRechargeReqToQueryWrapper(queryParam);

        Page<AdamTransaction> dataPage = adamTransactionMapper.selectPage(new Page<>(pageNum, pageSize), wrapper);

        return this.transferFromPoToDto(dataPage);
    }

    /**
     * 充值查询条件转换
     * @param queryParam
     * @return
     */
    private LambdaQueryWrapper<AdamTransaction> transferRechargeReqToQueryWrapper(AdamRechargeRecordReq queryParam){
        //查询条件
        LambdaQueryWrapper<AdamTransaction> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(!StringUtils.isEmpty(queryParam.getTransactionId()),AdamTransaction::getId, queryParam.getTransactionId());
        wrapper.eq(!StringUtils.isEmpty(queryParam.getWalletNo()),AdamTransaction::getFinWalletNo, queryParam.getWalletNo());
        wrapper.eq(!StringUtils.isEmpty(queryParam.getCurrency()),AdamTransaction::getCurrency, queryParam.getCurrency());
        //ge 表达式中如果使用new BigDecimal，只能使用下面的方式 ，ge(boolean condition, R column, Object val)会报空指针
        if(!StringUtils.isEmpty(queryParam.getTransactionAmountBegin())){
            wrapper.ge(AdamTransaction::getFundAmount, new BigDecimal(queryParam.getTransactionAmountBegin()));
        }
        if(!StringUtils.isEmpty(queryParam.getTransactionAmountEnd())){
            wrapper.le(AdamTransaction::getFundAmount, new BigDecimal(queryParam.getTransactionAmountEnd()));
        }

        if(!StringUtils.isEmpty(queryParam.getCreateDateBegin())){
            wrapper.ge(AdamTransaction::getCreateTime, queryParam.getCreateDateBegin());
        }
        if(!StringUtils.isEmpty(queryParam.getCreateDateEnd())){
            try {
                wrapper.le(AdamTransaction::getCreateTime, DateUtil.addDay(DateUtil.parse(queryParam.getCreateDateEnd(),DateUtil.DATE_SMALL_STR),1));
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }

        if(!StringUtils.isEmpty(queryParam.getCompletedDateBegin())){
            wrapper.ge(AdamTransaction::getCompleteTime, queryParam.getCompletedDateBegin());
        }
        if(!StringUtils.isEmpty(queryParam.getCompletedDateEnd())){
            try {
                wrapper.le(AdamTransaction::getCompleteTime, DateUtil.addDay(DateUtil.parse(queryParam.getCompletedDateEnd(),DateUtil.DATE_SMALL_STR),1));
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }

        wrapper.eq(!StringUtils.isEmpty(queryParam.getTransactionStatus()),AdamTransaction::getStatus, queryParam.getTransactionStatus());
        wrapper.eq(AdamTransaction::getType, AdamTransactionConstants.TypeEnum.FUNDING.getCode());
        return wrapper;
    }

    /**
     * 下发列表查询
     * @param pageNum
     * @param pageSize
     * @param queryParam
     * @param comId
     * @return
     */
    @Override
    public Page<AdamTransactionDto> queryPayoutPageList(int pageNum, int pageSize, AdamPayoutRecordReq queryParam, String comId) {
        //拼装查询条件
        LambdaQueryWrapper<AdamTransaction> wrapper = this.transferPayoutReqToQueryWrapper(queryParam);

        Page<AdamTransaction> dataPage = adamTransactionMapper.selectPage(new Page<>(pageNum, pageSize), wrapper);

        return this.transferFromPoToDto(dataPage);
    }

    /**
     * 下发查询条件转换
     * @param queryParam
     * @return
     */
    private LambdaQueryWrapper<AdamTransaction> transferPayoutReqToQueryWrapper(AdamPayoutRecordReq queryParam){
        //查询条件
        LambdaQueryWrapper<AdamTransaction> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(!StringUtils.isEmpty(queryParam.getTransactionId()),AdamTransaction::getId, queryParam.getTransactionId());
        wrapper.eq(!StringUtils.isEmpty(queryParam.getWalletNo()),AdamTransaction::getFinWalletNo, queryParam.getWalletNo());
        wrapper.eq(!StringUtils.isEmpty(queryParam.getCurrency()),AdamTransaction::getCurrency, queryParam.getCurrency());
        //ge 表达式中如果使用new BigDecimal，只能使用下面的方式 ，ge(boolean condition, R column, Object val)会报空指针
        if(!StringUtils.isEmpty(queryParam.getTransactionAmountBegin())){
            wrapper.ge(AdamTransaction::getFundAmount, new BigDecimal(queryParam.getTransactionAmountBegin()));
        }
        if(!StringUtils.isEmpty(queryParam.getTransactionAmountEnd())){
            wrapper.le(AdamTransaction::getFundAmount, new BigDecimal(queryParam.getTransactionAmountEnd()));
        }

        if(!StringUtils.isEmpty(queryParam.getTransactionDateBegin())){
            wrapper.ge(AdamTransaction::getCreateTime, queryParam.getTransactionDateBegin());
        }
        if(!StringUtils.isEmpty(queryParam.getTransactionDateEnd())){
            try {
                wrapper.le(AdamTransaction::getCreateTime, DateUtil.addDay(DateUtil.parse(queryParam.getTransactionDateEnd(),DateUtil.DATE_SMALL_STR),1));
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }

        if(!StringUtils.isEmpty(queryParam.getExecutionDateBegin())){
            wrapper.ge(AdamTransaction::getCompleteTime, queryParam.getExecutionDateBegin());
        }
        if(!StringUtils.isEmpty(queryParam.getExecutionDateEnd())){
            try {
                wrapper.le(AdamTransaction::getCompleteTime, DateUtil.addDay(DateUtil.parse(queryParam.getExecutionDateEnd(),DateUtil.DATE_SMALL_STR),1));
            } catch (ParseException e) {
                e.printStackTrace();
            }
        }

        wrapper.eq(!StringUtils.isEmpty(queryParam.getTransactionStatus()),AdamTransaction::getStatus, queryParam.getTransactionStatus());
        wrapper.eq(AdamTransaction::getType, AdamTransactionConstants.TypeEnum.PAYOUT.getCode());
        return wrapper;
    }

    /**
     * 换汇列表查询
     * @param pageNum
     * @param pageSize
     * @param queryParam
     * @param comId
     * @return
     */
    @Override
    public Page<AdamTransactionDto> queryConversionPageList(int pageNum, int pageSize, AdamConversionRecordReq queryParam, String comId) {
        //拼装查询条件
        LambdaQueryWrapper<AdamTransaction> wrapper = this.transferConversionReqToQueryWrapper(queryParam);

        Page<AdamTransaction> dataPage = adamTransactionMapper.selectPage(new Page<>(pageNum, pageSize), wrapper);

        return this.transferFromPoToDto(dataPage);
    }

    @Override
    public AdamPayoutDetailDto getPayoutDetailByOrderId(String orderId) {
        AdamPayoutDetailDto adamPayoutDetailDto = new AdamPayoutDetailDto();
        AdamPayout adamPayout = adamPayoutMapper.selectById(orderId);
        AdamPayoutPayer adamPayoutPayer = adamPayoutPayerMapper.selectById(orderId);
        AdamPayoutBeneficiary adamPayoutBeneficiary = adamPayoutBeneficiaryMapper.selectById(orderId);
        adamPayoutDetailDto.setAdamPayout(adamPayout);
        adamPayoutDetailDto.setAdamPayoutPayer(adamPayoutPayer);
        adamPayoutDetailDto.setAdamPayoutBeneficiary(adamPayoutBeneficiary);
        return adamPayoutDetailDto;
    }

    /**
     * 换汇查询条件转换
     * @param queryParam
     * @return
     */
    private LambdaQueryWrapper<AdamTransaction> transferConversionReqToQueryWrapper(AdamConversionRecordReq queryParam){
        //查询条件
        LambdaQueryWrapper<AdamTransaction> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(!StringUtils.isEmpty(queryParam.getTransactionId()),AdamTransaction::getId, queryParam.getTransactionId());
//        wrapper.eq(!StringUtils.isEmpty(queryParam.getWalletNo()),AdamTransaction::getFinWalletNo, queryParam.getWalletNo());
//        wrapper.eq(!StringUtils.isEmpty(queryParam.getCurrency()),AdamTransaction::getCurrency, queryParam.getCurrency());
//        //ge 表达式中如果使用new BigDecimal，只能使用下面的方式 ，ge(boolean condition, R column, Object val)会报空指针
//        if(!StringUtils.isEmpty(queryParam.getTransactionAmountBegin())){
//            wrapper.ge(AdamTransaction::getFundAmount, new BigDecimal(queryParam.getTransactionAmountBegin()));
//        }
//        if(!StringUtils.isEmpty(queryParam.getTransactionAmountEnd())){
//            wrapper.le(AdamTransaction::getFundAmount, new BigDecimal(queryParam.getTransactionAmountEnd()));
//        }
//
//        if(!StringUtils.isEmpty(queryParam.getTransactionDateBegin())){
//            wrapper.ge(AdamTransaction::getCreateTime, queryParam.getTransactionDateBegin());
//        }
//        if(!StringUtils.isEmpty(queryParam.getTransactionDateEnd())){
//            try {
//                wrapper.le(AdamTransaction::getCreateTime, DateUtil.addDay(DateUtil.parse(queryParam.getTransactionDateEnd(),DateUtil.DATE_SMALL_STR),1));
//            } catch (ParseException e) {
//                e.printStackTrace();
//            }
//        }
//
//        if(!StringUtils.isEmpty(queryParam.getExecutionDateBegin())){
//            wrapper.ge(AdamTransaction::getCompleteTime, queryParam.getExecutionDateBegin());
//        }
//        if(!StringUtils.isEmpty(queryParam.getExecutionDateEnd())){
//            try {
//                wrapper.le(AdamTransaction::getCompleteTime, DateUtil.addDay(DateUtil.parse(queryParam.getExecutionDateEnd(),DateUtil.DATE_SMALL_STR),1));
//            } catch (ParseException e) {
//                e.printStackTrace();
//            }
//        }
        wrapper.eq(!StringUtils.isEmpty(queryParam.getTransactionStatus()),AdamTransaction::getStatus, queryParam.getTransactionStatus());
        wrapper.eq(AdamTransaction::getType, AdamTransactionConstants.TypeEnum.FX_CONVERSION.getCode());
        return wrapper;
    }

    /**
     * 转换po为vo
     * @param poPage
     * @return
     */
    private Page<AdamTransactionDto> transferFromPoToDto(Page<AdamTransaction> poPage){
        List<AdamTransaction> records = poPage.getRecords();

        List<AdamTransactionDto> dtoRecords = records.stream().map(po ->{
            AdamTransactionDto dto = new AdamTransactionDto();
            BeanUtils.copyProperties(po, dto);
            return dto;
        }).collect(Collectors.toList());

        Page<AdamTransactionDto> page = new Page<>();
        BeanUtils.copyProperties(poPage, page);
        page.setRecords(dtoRecords);
        return page;
    }


}
