package com.liquidnet.service.adam.service.feign.bank;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.common.AdamErrorCode;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.service.feign.bank.IAdamFeignBankCcAccountService;
import com.liquidnet.service.bank.currencycloud.dto.BankCcAccountCreateDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcAccountCreateParam;
import com.liquidnet.service.feign.bank.api.currencycloud.FeignBankCcAccountClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class AdamFeignBankCcAccountServiceImpl implements IAdamFeignBankCcAccountService {

    @Autowired
    private FeignBankCcAccountClient feignBankCcAccountClient;

    @Override
    public AdamResultDto<BankCcAccountCreateDto> create(BankCcAccountCreateParam param) {
        String logFx = param.getBankCcContactParam().getLoginId() + ",adam create cc account.";
        try {
            ResponseDto<BankCcAccountCreateDto> responseDto = feignBankCcAccountClient.create(param);
            return AdamResultDto.getAdamResultDto(responseDto);
        } catch (Exception e) {
            log.error(logFx + "error,BankCcAccountCreateParam=[{}]", JsonUtils.toJson(param), e);
            return AdamResultDto.failure(AdamErrorCode.ADAM_FEGIN_BANK_CC_200001);
        }
    }

}
