package com.liquidnet.service.adam.service.feign.bank;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.common.AdamErrorCode;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.service.feign.bank.IAdamFeignBankCcBalanceService;
import com.liquidnet.service.bank.currencycloud.entity.BankCcBalance;
import com.liquidnet.service.feign.bank.api.currencycloud.FeignBankCcBalanceClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class AdamFeignBankCcBalanceServiceImpl implements IAdamFeignBankCcBalanceService {

    @Autowired
    private FeignBankCcBalanceClient feignBankCcBalanceClient;

    @Override
    public AdamResultDto<BankCcBalance> retrieveBalance(String currency, String contactId) {
        String logFx = contactId + ",adam retrieve cc balance.";
        try {
            ResponseDto<BankCcBalance> responseDto = feignBankCcBalanceClient.retrieveBalance(currency, contactId);
            return AdamResultDto.getAdamResultDto(responseDto);
        } catch (Exception e) {
            log.error(logFx + "error,currency=[{}]", currency, e);
            return AdamResultDto.failure(AdamErrorCode.ADAM_FEGIN_BANK_CC_200001);
        }

    }

}
