package com.liquidnet.service.adam.service.feign.bank;

import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.common.AdamErrorCode;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.service.feign.bank.IAdamFeignBankCcBeneficiaryService;
import com.liquidnet.service.feign.bank.api.currencycloud.FeignBankCcBeneficiaryClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class AdamFeignBankCcBeneficiaryServiceImpl implements IAdamFeignBankCcBeneficiaryService {

    @Autowired
    private FeignBankCcBeneficiaryClient feignBankCcBeneficiaryClient;

    @Override
    public AdamResultDto<List<Map<String, String>>> requiredDetails(String currency, String bankAccountCountry, String beneficiaryCountry) {

        String logFx = "adam required cc beneficiary details";
        try {
            ResponseDto<List<Map<String, String>>> listResponseDto = feignBankCcBeneficiaryClient.requiredDetails(currency, bankAccountCountry, beneficiaryCountry);
            return AdamResultDto.getAdamResultDto(listResponseDto);
        } catch (Exception e) {
            log.error(logFx + "error,currency=[{}],bankAccountCountry=[{}],beneficiaryCountry=[{}]", currency, bankAccountCountry, beneficiaryCountry, e);
            return AdamResultDto.failure(AdamErrorCode.ADAM_FEGIN_BANK_CC_200001);
        }
    }

}
