package com.liquidnet.service.adam.service.feign.bank;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.common.AdamErrorCode;
import com.liquidnet.service.adam.constant.AdamConversionConstants;
import com.liquidnet.service.adam.dto.AdamConversionParam;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.entity.AdamBankCcAccount;
import com.liquidnet.service.adam.service.IAdamBankCcAccountService;
import com.liquidnet.service.bank.currencycloud.dto.BankCcConversionDatesDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcConversionDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcConversionCreateParam;
import com.liquidnet.service.feign.bank.api.currencycloud.FeignBankCcConversionClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class AdamFeignBankCcConversionServiceImpl implements IAdamFeignBankCcConversionService {

    @Autowired
    private FeignBankCcConversionClient feignBankCcConversionClient;

    @Autowired
    private IAdamBankCcAccountService adamBankCcAccountService;

    @Override
    public AdamResultDto<BankCcConversionDto> createConversion(AdamConversionParam param) {

        String logFx = param.getId() + ",adam create cc conversion";
        try {
            BankCcConversionCreateParam ccParam = new BankCcConversionCreateParam();
            String fixedSide = param.getFixedSide();
            ccParam.setBuyCurrency(param.getBuyCurrency());
            ccParam.setSellCurrency(param.getSellCurrency());
            ccParam.setFixedSide(fixedSide);
            ccParam.setUniqueRequestId(param.getId());

            if (AdamConversionConstants.FixedSideEnum.BUY.getCode().equals(fixedSide)) {
                ccParam.setAmount(param.getBuyAmount());
            } else {
                ccParam.setAmount(param.getSellAmount());
            }
            AdamBankCcAccount adamBankCcAccount = adamBankCcAccountService.selectById(param.getComId());
            ccParam.setContactId(adamBankCcAccount.getContactId());
            ccParam.setConversionDate(DateUtil.parse(param.getConversionDateAt(), "yyyy-MM-dd"));
            ResponseDto<BankCcConversionDto> conversionResponseDto = feignBankCcConversionClient.createConversion(ccParam);
            return AdamResultDto.getAdamResultDto(conversionResponseDto);
        } catch (Exception e) {
            log.error(logFx + "error", e);
            return AdamResultDto.failure(AdamErrorCode.ADAM_FEGIN_BANK_CC_200001);
        }
    }

    @Override
    public AdamResultDto<BankCcConversionDatesDto> getConversionDates(String conversionPair, String startDate) {
        String logFx = "adam get cc conversion dates";
        try {
            ResponseDto<BankCcConversionDatesDto> responseDto = feignBankCcConversionClient.getConversionDates(conversionPair, startDate);
            return AdamResultDto.getAdamResultDto(responseDto);
        } catch (Exception e) {
            log.error(logFx + "error", e);
            return AdamResultDto.failure(AdamErrorCode.ADAM_FEGIN_BANK_CC_200001);
        }
    }

}
