package com.liquidnet.service.adam.service.feign.bank;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.common.AdamErrorCode;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcFundingAccountDto;
import com.liquidnet.service.feign.bank.api.currencycloud.FeignBankCcFundingClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
public class AdamFeignBankCcFundingServiceImpl implements IAdamFeignBankCcFundingService {

    @Autowired
    private FeignBankCcFundingClient feignBankCcFundingClient;

    @Override
    public AdamResultDto<List<BankCcFundingAccountDto>> getFundingAccount(String accountId, String currency) {
        try {
            ResponseDto<List<BankCcFundingAccountDto>> responseDto = feignBankCcFundingClient.getFundingAccount(accountId, currency);
            return AdamResultDto.getAdamResultDto(responseDto);
        } catch (Exception e) {
            log.error("adam get cc funding account error,accountId=[{}],currency=[{}]", accountId, currency, e);
            return AdamResultDto.failure(AdamErrorCode.ADAM_FEGIN_BANK_CC_200001);
        }
    }

}
