package com.liquidnet.service.adam.service.feign.bank;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.constant.AdamBeneficiaryConstants;
import com.liquidnet.service.adam.constant.AdamPayerConstants;
import com.liquidnet.service.adam.dto.AdamPayoutMethodDto;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.entity.AdamBankCcAccount;
import com.liquidnet.service.adam.entity.AdamPayout;
import com.liquidnet.service.adam.entity.AdamPayoutBeneficiary;
import com.liquidnet.service.adam.entity.AdamPayoutPayer;
import com.liquidnet.service.adam.service.*;
import com.liquidnet.service.bank.currencycloud.dto.BankCcBeneficiaryParam;
import com.liquidnet.service.bank.currencycloud.dto.BankCcPayerParam;
import com.liquidnet.service.bank.currencycloud.dto.BankCcPaymentCreateParam;
import com.liquidnet.service.bank.currencycloud.dto.BankCcPaymentParam;
import com.liquidnet.service.bank.currencycloud.entity.BankCcPayment;
import com.liquidnet.service.feign.bank.api.currencycloud.FeignBankCcPaymentClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Slf4j
@Service
public class AdamFeignBankCcPaymentServiceImpl implements IAdamFeignBankCcPaymentService {

    @Autowired
    private FeignBankCcPaymentClient feignBankCcPaymentClient;

    @Autowired
    private IAdamPayoutService adamPayoutService;

    @Autowired
    private IAdamPayoutBeneficiaryService adamPayoutBeneficiaryService;

    @Autowired
    private IAdamPayoutPayerService adamPayoutPayerService;

    @Autowired
    private IAdamBankCcAccountService adamBankCcAccountService;

    @Autowired
    private IAdamSysCountryService adamSysCountryService;

    @Override
    public AdamResultDto<BankCcPayment> createPayment(String payoutId) {

        // 查询payout下发信息,收款人信息,付款人信息
        AdamPayout payout = adamPayoutService.selectById(payoutId);
        AdamPayoutBeneficiary payoutBeneficiary = adamPayoutBeneficiaryService.selectById(payoutId);
        AdamPayoutPayer payoutPayer = adamPayoutPayerService.selectById(payoutId);

        // 查询cc下发使用的contactId
        AdamBankCcAccount adamBankCcAccount = adamBankCcAccountService.selectById(payout.getComId());
        String contactId = adamBankCcAccount.getContactId();

        // 初始化cc下发参数
        BankCcPaymentParam ccPayment = new BankCcPaymentParam();

        ccPayment.setCurrency(payout.getCurrency());
        ccPayment.setAmount(adamSysCountryService.accuracy(payout.getAmount(), payout.getCurrency()));
        ccPayment.setReason(payout.getReason());
        ccPayment.setReference(payout.getReference());
        ccPayment.setPaymentDate(Date.from(payout.getExecutionDate().atStartOfDay(ZoneOffset.UTC).toInstant()));
        ccPayment.setPaymentType(payoutBeneficiary.getPaymentMethodUse());
        ccPayment.setCreatorContactId(contactId);
        ccPayment.setUniqueRequestId(payoutId);

//        ccPayment.setBeneficiaryId("");
//        ccPayment.setChargeType("");
//        ccPayment.setConversionId("");
//        ccPayment.setShortReference("");
//        ccPayment.setUltimateBeneficiaryName("");
//        ccPayment.setPurposeCode("");
//        ccPayment.setFeeAmount(null);
//        ccPayment.setFeeCurrency("");
//        ccPayment.setPayerId("");

        BankCcBeneficiaryParam ccBeneficiary = new BankCcBeneficiaryParam();
        ccBeneficiary.setUniqueRequestId(payoutBeneficiary.getId());
        ccBeneficiary.setName(payoutBeneficiary.getNickName());
        ccBeneficiary.setBankAccountHolderName(payoutBeneficiary.getFullName());
        ccBeneficiary.setBankCountry(payoutBeneficiary.getBankCountry());
        ccBeneficiary.setCurrency(payoutBeneficiary.getCurrency());
        ccBeneficiary.setBeneficiaryAddress(Lists.newArrayList(payoutBeneficiary.getAddress()));
        ccBeneficiary.setBeneficiaryEntityType(payoutBeneficiary.getLegalEntityType());
        ccBeneficiary.setAccountNumber(payoutBeneficiary.getBankAccountNo());
        ccBeneficiary.setBeneficiaryCountry(payoutBeneficiary.getCountry());
        ccBeneficiary.setBeneficiaryCity(payoutBeneficiary.getCity());
        if ("US".equals(payoutBeneficiary.getCountry())) {
            ccBeneficiary.setBeneficiaryPostcode(payoutBeneficiary.getPostCode());
            ccBeneficiary.setBeneficiaryStateOrProvince(payoutBeneficiary.getProvince());
        }
        if (AdamBeneficiaryConstants.LegalEntityTypeEnum.INDIVIDUAL.getCode().equals(payoutBeneficiary.getLegalEntityType())) {
            ccBeneficiary.setBeneficiaryFirstName(payoutBeneficiary.getFirstName());
            ccBeneficiary.setBeneficiaryLastName(payoutBeneficiary.getLastName());
        } else if (AdamBeneficiaryConstants.LegalEntityTypeEnum.COMPANY.getCode().equals(payoutBeneficiary.getLegalEntityType())) {
            ccBeneficiary.setBeneficiaryCompanyName(payoutBeneficiary.getFullName());
        }

        ccBeneficiary.setPaymentTypes(Lists.newArrayList(payoutBeneficiary.getPaymentMethodUse()));
        ccBeneficiary.setCreatorContactId(contactId);

        // 收款人接收的付款方式
        List<AdamPayoutMethodDto> list = JSON.parseArray(payoutBeneficiary.getPaymentMethodDetail(), AdamPayoutMethodDto.class);
        for (AdamPayoutMethodDto methodDto : list) {
            if (payoutBeneficiary.getPaymentMethodUse().equals(methodDto.getPaymentType())) {
                List<AdamPayoutMethodDto.Content> contentList = methodDto.getContent();
                for (AdamPayoutMethodDto.Content content : contentList) {
                    String code = content.getCode();
                    String val = content.getVal();
                    if ("bank_name".equals(code)) {
                        ccBeneficiary.setBankName(val);
                    } else if ("bank_address".equals(code)) {
                        ccBeneficiary.setBankAddress(Lists.newArrayList(val));
                    } else if ("bic_swift".equals(code)) {
                        ccBeneficiary.setBicSwift(val);
                    } else if ("aba".equals(code) || "bank_code".equals(code) || "cnaps".equals(code)) {
                        if (StringUtils.isEmpty(ccBeneficiary.getRoutingCodeType1())) {
                            ccBeneficiary.setRoutingCodeType1(code);
                            ccBeneficiary.setRoutingCodeValue1(val);
                        } else {
                            ccBeneficiary.setRoutingCodeType2(code);
                            ccBeneficiary.setRoutingCodeValue2(val);
                        }

                    }
                }

            }
        }
        ;

//        ccBeneficiary.setId("");
//        ccBeneficiary.setEmail("");
//        ccBeneficiary.setDefaultBeneficiary(false);
//        ccBeneficiary.setCreatedAt(new Date());
//        ccBeneficiary.setUpdatedAt(new Date());
//        ccBeneficiary.setBankAccountType("");
//        ccBeneficiary.setBeneficiaryDateOfBirth(new Date());
//        ccBeneficiary.setBeneficiaryIdentificationType("");
//        ccBeneficiary.setBeneficiaryIdentificationValue("");
//        ccBeneficiary.setBeneficiaryExternalReference("");
//        ccBeneficiary.setIban("");
//        ccBeneficiary.setScope("");

        BankCcPayerParam ccPayer = new BankCcPayerParam();
        ccPayer.setLegalEntityType(payoutPayer.getLegalEntityType());
        ccPayer.setCompanyName(payoutPayer.getFullName());
        ccPayer.setFirstName(payoutPayer.getFirstName());
        ccPayer.setLastName(payoutPayer.getLastName());
        List<String> arrayList = new ArrayList<>();
        arrayList.add(payoutPayer.getAddress());
        ccPayer.setAddress(arrayList);
        ccPayer.setCity(payoutPayer.getCity());
        ccPayer.setStateOrProvince(payoutPayer.getProvince());
        ccPayer.setCountry(payoutPayer.getCountry());
        if (AdamPayerConstants.LegalEntityTypeEnum.COMPANY.getCode().equals(payoutPayer.getLegalEntityType())) {
            //  产品要求,字段payer_identification_type写死值"incorporation_number"
            ccPayer.setIdentificationType("incorporation_number");
        }else{
            ccPayer.setIdentificationType(payoutPayer.getIdType());
        }
        ccPayer.setIdentificationValue(payoutPayer.getIdNumber());
//        ccPayer.setPostcode("");
//        ccPayer.setDateOfBirth(null);

        BankCcPaymentCreateParam param = new BankCcPaymentCreateParam();
        param.setContactId(contactId);
        param.setPaymentParam(ccPayment);
        param.setBeneficiaryParam(ccBeneficiary);
        param.setPayerParam(ccPayer);

        ResponseDto<BankCcPayment> paymentResponseDto = feignBankCcPaymentClient.create(param);
        return AdamResultDto.getAdamResultDto(paymentResponseDto);
    }

}
