package com.liquidnet.service.adam.service.feign.bank;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.common.AdamErrorCode;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcRateDto;
import com.liquidnet.service.bank.currencycloud.dto.BankCcRateParam;
import com.liquidnet.service.feign.bank.api.currencycloud.FeignBankCcRateClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class AdamFeignBankCcRateServiceImpl implements IAdamFeignBankCcRateService {

    @Autowired
    private FeignBankCcRateClient feignBankCcRateClient;

    @Override
    public ResponseDto<BankCcRateDto> detailedRate(BankCcRateParam param) {
        try {
            return feignBankCcRateClient.detailedRate(param);
        } catch (Exception e) {
            log.error("adam get cc detailed rate error", e);
            return ResponseDto.failure(AdamErrorCode.ADAM_FEGIN_BANK_CC_200001.getCode(), AdamErrorCode.ADAM_FEGIN_BANK_CC_200001.getVal());
        }

    }

}
