package com.liquidnet.service.adam.service.feign.fin;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageInfo;
import com.liquidnet.service.account.wallet.dto.*;
import com.liquidnet.service.account.wallet.dto.base.WalletCallParam;
import com.liquidnet.service.account.wallet.vo.WalletAccountInfoVo;
import com.liquidnet.service.account.wallet.vo.WalletDashboardInfoVo;
import com.liquidnet.service.account.wallet.vo.WalletTransactionInfoVo;
import com.liquidnet.service.adam.common.AdamErrorCode;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.service.feign.fin.IAdamFeignAccountService;
import com.liquidnet.service.adam.util.PageUtil;
import com.liquidnet.service.feign.account.api.FeignAccountClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class AdamFeignAccountServiceImpl implements IAdamFeignAccountService {

    @Autowired
    private FeignAccountClient feignAccountClient;

    @Override
    public AdamResultDto<WalletAccountInfoVo> getWallet(String userId, String finWalletNo) {
        String logFx = "adam fegin account get wallet.finWalletNo=[" + finWalletNo + "].";
        try {
            AdamResultDto<WalletAccountInfoVo> resultDto = AdamResultDto.success();
            WalletQueryParam param = new WalletQueryParam();
            param.setUserExtId(userId);
            param.setWalletNo(finWalletNo);
            param.setStatus(1);
            initWalletCallParam(param);

            WalletQueryResult query = feignAccountClient.query(param);
            if (!query.isSuccess()) {
                return AdamResultDto.failure(query.getCode(), query.getMessage());
            }

            List<WalletAccountInfoVo> list = query.getPageInfo().getList();
            if (CollectionUtils.isEmpty(list)) {
                return AdamResultDto.failure(AdamErrorCode.ADAM_WALLET_005004);
            }
            resultDto.setData(list.get(0));
            return resultDto;
        } catch (Exception e) {
            log.error(logFx + "error", e);
            return AdamResultDto.failure(AdamErrorCode.ADAM_FEGIN_ACCOUNT_100001);
        }
    }

    @Override
    public AdamResultDto<WalletRegisterResult> register(String userId, String userName, String walletName, String currency) {
        AdamResultDto<WalletRegisterResult> resultDto = AdamResultDto.success();
        String logFx = "adam fegin account register wallet.userId=[" + userId + "].";
        try {
            WalletRegisterParam walletRegisterParam = new WalletRegisterParam();
            walletRegisterParam.setUserExtId(userId);
            walletRegisterParam.setUserExtName(userName);
            walletRegisterParam.setCurrency(currency);
            walletRegisterParam.setAlias(walletName);
            initWalletCallParam(walletRegisterParam);
            WalletRegisterResult register = feignAccountClient.register(walletRegisterParam);
            log.info(logFx + "result=[{}]", JSON.toJSONString(register, SerializerFeature.WriteMapNullValue));
            if (register.isSuccess()) {
                resultDto.setData(register);
            } else {
                resultDto.setCode(register.getCode());
                resultDto.setMessage(register.getMessage());
            }
        } catch (Exception e) {
            log.error(logFx + "error,finWalletNo=[{}]", e);
            return AdamResultDto.failure(AdamErrorCode.ADAM_FEGIN_ACCOUNT_100001);
        }
        return resultDto;
    }

    @Override
    public AdamResultDto<Map<String, List<WalletDashboardInfoVo>>> dashboardShow(WalletDashboardParam param) {
        initWalletCallParam(param);
        try {
            WalletDashboardResult query = feignAccountClient.dashboardShow(param);
            if (!query.isSuccess()) {
                return AdamResultDto.failure(query.getCode(), query.getMessage());
            }
            return AdamResultDto.success(query.getVoMap());
        } catch (Exception e) {
            log.error("account dashboard show error", e);
            return AdamResultDto.failure(AdamErrorCode.ADAM_FEGIN_ACCOUNT_100001);
        }
    }

    @Override
    public WalletEditResult edit(WalletEditParam param) {
        initWalletCallParam(param);
        return feignAccountClient.edit(param);
    }

    @Override
    public AdamResultDto<Page<WalletAccountInfoVo>> listPage(WalletQueryParam param) {
        initWalletCallParam(param);
        param.setStatus(1);
        WalletQueryResult query = feignAccountClient.query(param);
        if (!query.isSuccess()) {
            return AdamResultDto.failure(query.getCode(), query.getMessage());
        }

        PageInfo<WalletAccountInfoVo> pageInfo = query.getPageInfo();
        Page page = PageUtil.transferFromPageInfo(pageInfo);
        return AdamResultDto.success(page);
    }

    @Override
    public AdamResultDto<List<WalletAccountInfoVo>> list(WalletQueryParam param) {
        initWalletCallParam(param);
        param.setStatus(1);
        WalletQueryResult query = feignAccountClient.query(param);
        if (!query.isSuccess()) {
            return AdamResultDto.failure(query.getCode(), query.getMessage());
        }
        return AdamResultDto.success(query.getPageInfo().getList());
    }

    @Override
    public AdamResultDto<String> transaction(WalletTransactionParam param) {

        String logFx = "adam fegin account transaction,tracingNo=[" + param.getTracingNo() + "].";
        try {
            initWalletCallParam(param);
            log.info(logFx + "param WalletTransactionParam=[{}]", JSON.toJSONString(param));
            WalletTransactionResult result = feignAccountClient.transaction(param);
            if (result.isSuccess()) {
                return AdamResultDto.success(result.getTransNo());
            } else {
                return AdamResultDto.failure(result.getCode(), result.getMessage());
            }
        } catch (Exception e) {
            log.error(logFx + "error", e);
            return AdamResultDto.failure(AdamErrorCode.ADAM_FEGIN_ACCOUNT_100001);
        }
    }

    @Override
    public AdamResultDto<List<WalletTransactionInfoVo>> transactionQuery(WalletTransactionQueryParam param) {
        String logFx = "adam fegin account transactionQuery .";
        try {
            initWalletCallParam(param);
            log.info(logFx + "param WalletTransactionQueryParam=[{}]", JSON.toJSONString(param));
            WalletTransactionQueryResult result = feignAccountClient.transactionQuery(param);

            if (result.isSuccess()) {
                return AdamResultDto.success(result.getTransDetailList());
            } else {
                return AdamResultDto.failure(result.getCode(), result.getMessage());
            }
        } catch (Exception e) {
            log.error(logFx + "error", e);
            return AdamResultDto.failure(AdamErrorCode.ADAM_FEGIN_ACCOUNT_100001);
        }
    }

    public static void initWalletCallParam(WalletCallParam walletCallParam) {
        walletCallParam.setChannelId("50001");
        walletCallParam.setBizType("000");
    }

}
