package com.liquidnet.service.adam.service.impl;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.service.IAdamAccountAsyncService;
import com.liquidnet.service.adam.service.IAdamAccountApiService;
import com.liquidnet.service.adam.service.feign.bank.IAdamFeignBankCcBalanceService;
import com.liquidnet.service.bank.currencycloud.entity.BankCcBalance;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 账户 异步服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-13
 */
@Service
@Slf4j
public class AdamAccountAsyncServiceImpl implements IAdamAccountAsyncService {

    @Autowired
    IAdamFeignBankCcBalanceService adamFeignBankCcBalanceService;

    @Autowired
    IAdamAccountApiService adamAccountApiService;

    @Override
    @Async
    public void ccAsyncRetrieveBalance(String currency, String ccContractId) {
        AdamResultDto<BankCcBalance> bankCcBalanceAdamResultDto = adamFeignBankCcBalanceService.retrieveBalance(currency, ccContractId);
        if (bankCcBalanceAdamResultDto.isSuccess()) {
            adamAccountApiService.pushNotifyBankCcBalance(bankCcBalanceAdamResultDto.getData());
        }

    }

}
