package com.liquidnet.service.adam.service.impl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.liquidnet.service.adam.dto.AdamAccountParam;
import com.liquidnet.service.adam.entity.AdamAccount;
import com.liquidnet.service.adam.mapper.AdamAccountMapper;
import com.liquidnet.service.adam.service.IAdamAccountService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;

/**
 * <p>
 * 公司账户 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-13
 */
@Service
@Slf4j
public class AdamAccountServiceImpl implements IAdamAccountService {

    @Autowired
    AdamAccountMapper adamAccountMapper;

    @Override
    public AdamAccount selectById(String id) {
        return adamAccountMapper.selectById(id);
    }

    @Override
    public AdamAccount selectById(String id, String state) {
        AdamAccountParam param = new AdamAccountParam();
        param.setId(id);
        param.setState(state);
        return this.selectOne(param);
    }

    @Override
    public AdamAccount selectOne(AdamAccountParam param) {
        QueryWrapper<AdamAccount> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .eq(!StringUtils.isEmpty(param.getId()), AdamAccount::getId, param.getId())
                .eq(!StringUtils.isEmpty(param.getComId()), AdamAccount::getComId, param.getComId())
                .eq(!StringUtils.isEmpty(param.getBankId()), AdamAccount::getBankId, param.getBankId())
                .eq(!StringUtils.isEmpty(param.getBankChannel()), AdamAccount::getBankChannel, param.getBankChannel())
                .eq(!StringUtils.isEmpty(param.getState()), AdamAccount::getState, param.getState())
        ;
        return adamAccountMapper.selectOne(queryWrapper);
    }

    @Override
    public int insert(AdamAccount param) {
        return adamAccountMapper.insert(param);
    }

    @Override
    public int updateById(AdamAccount param) {
        param.setUpdateTime(LocalDateTime.now());
        return adamAccountMapper.updateById(param);
    }

}
