package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.liquidnet.service.adam.constant.AdamAccountConstants;
import com.liquidnet.service.adam.dto.AdamAccountWalletParam;
import com.liquidnet.service.adam.entity.AdamAccountWallet;
import com.liquidnet.service.adam.mapper.AdamAccountWalletMapper;
import com.liquidnet.service.adam.service.IAdamAccountWalletService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 账户钱包 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-19
 */
@Service
public class AdamAccountWalletServiceImpl implements IAdamAccountWalletService {

    @Autowired
    AdamAccountWalletMapper adamAccountWalletMapper;

    @Override
    public AdamAccountWallet selectOne(AdamAccountWalletParam param) {
        QueryWrapper<AdamAccountWallet> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .eq(!StringUtils.isEmpty(param.getComId()), AdamAccountWallet::getComId, param.getComId())
                .eq(!StringUtils.isEmpty(param.getAccountId()), AdamAccountWallet::getAccountId, param.getAccountId())
                .eq(!StringUtils.isEmpty(param.getCurrency()), AdamAccountWallet::getCurrency, param.getCurrency())
                .eq(!StringUtils.isEmpty(param.getState()), AdamAccountWallet::getState, param.getState())
                .eq(!StringUtils.isEmpty(param.getFinWalletNo()), AdamAccountWallet::getFinWalletNo, param.getFinWalletNo())
                .eq(!StringUtils.isEmpty(param.getBankWalletId()), AdamAccountWallet::getBankWalletId, param.getBankWalletId())
                .eq(!StringUtils.isEmpty(param.getBankChannel()), AdamAccountWallet::getBankChannel, param.getBankChannel())
        ;
        return adamAccountWalletMapper.selectOne(queryWrapper);
    }

    @Override
    public List<AdamAccountWallet> selectList(AdamAccountWalletParam param) {
        QueryWrapper<AdamAccountWallet> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .eq(!StringUtils.isEmpty(param.getComId()), AdamAccountWallet::getComId, param.getComId())
                .eq(!StringUtils.isEmpty(param.getAccountId()), AdamAccountWallet::getAccountId, param.getAccountId())
                .eq(!StringUtils.isEmpty(param.getCurrency()), AdamAccountWallet::getCurrency, param.getCurrency())
                .eq(!StringUtils.isEmpty(param.getState()), AdamAccountWallet::getState, param.getState())
                .eq(!StringUtils.isEmpty(param.getFinWalletNo()), AdamAccountWallet::getFinWalletNo, param.getFinWalletNo())
                .eq(!StringUtils.isEmpty(param.getBankWalletId()), AdamAccountWallet::getBankWalletId, param.getBankWalletId())
                .eq(!StringUtils.isEmpty(param.getBankChannel()), AdamAccountWallet::getBankChannel, param.getBankChannel())
        ;
        return adamAccountWalletMapper.selectList(queryWrapper);
    }

    @Override
    public int insert(AdamAccountWallet adamAccountWallet) {
        return adamAccountWalletMapper.insert(adamAccountWallet);
    }

    @Override
    public int updateById(AdamAccountWallet adamAccountWallet) {
        adamAccountWallet.setUpdateTime(LocalDateTime.now());
        return adamAccountWalletMapper.updateById(adamAccountWallet);
    }

    @Override
    public int deleteWallet(String comId, String finWalletNo) {
        // todo-lichen 未完成,删除钱包之前,校验钱包是否存在未完成状态的交易

        AdamAccountWallet wallet = new AdamAccountWallet();
        wallet.setState(AdamAccountConstants.StateEnum.S3.getCode());
        wallet.setDeleteDate(LocalDateTime.now());

        AdamAccountWalletParam param = new AdamAccountWalletParam();
        param.setComId(comId);
        param.setFinWalletNo(finWalletNo);
        param.setState(AdamAccountConstants.StateEnum.S2.getCode());
        return this.update(wallet, param);
    }

    @Override
    public int update(AdamAccountWallet adamAccountWallet, AdamAccountWalletParam param) {
        adamAccountWallet.setUpdateTime(LocalDateTime.now());
        UpdateWrapper<AdamAccountWallet> updateWrapper = new UpdateWrapper<>();
        updateWrapper.lambda()
                .eq(AdamAccountWallet::getFinWalletNo, param.getFinWalletNo())
                .eq(AdamAccountWallet::getComId, param.getComId())
                .eq(!StringUtils.isEmpty(param.getState()), AdamAccountWallet::getState, param.getState())
        ;

        return adamAccountWalletMapper.update(adamAccountWallet, updateWrapper);
    }

}
