package com.liquidnet.service.adam.service.impl;

import com.liquidnet.service.adam.dto.AdamComInfoExtendParam;
import com.liquidnet.service.adam.entity.AdamComInfoExtend;
import com.liquidnet.service.adam.mapper.AdamComInfoExtendMapper;
import com.liquidnet.service.adam.service.IAdamComInfoExtendService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * <p>
 * 公司信息扩展 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-16
 */
@Service
public class AdamComInfoExtendServiceImpl implements IAdamComInfoExtendService {

    @Autowired
    private AdamComInfoExtendMapper adamComInfoExtendMapper;

    @Override
    public AdamComInfoExtend selectById(String id) {
        return adamComInfoExtendMapper.selectById(id);
    }

    @Override
    public int insert(AdamComInfoExtendParam param) {
        AdamComInfoExtend adamComInfoExtend = new AdamComInfoExtend();
        BeanUtils.copyProperties(param, adamComInfoExtend);
        adamComInfoExtend.setCreateTime(LocalDateTime.now());
        return adamComInfoExtendMapper.insert(adamComInfoExtend);
    }

    @Override
    public int updateById(AdamComInfoExtendParam param) {
        AdamComInfoExtend adamComInfoExtend = new AdamComInfoExtend();
        BeanUtils.copyProperties(param, adamComInfoExtend);
        adamComInfoExtend.setUpdateTime(LocalDateTime.now());
        return adamComInfoExtendMapper.updateById(adamComInfoExtend);
    }

    @Override
    public AdamComInfoExtend selectByCountryCode(String comId, String countryCode) {
         return adamComInfoExtendMapper.selectByCountryCode(comId,countryCode);
    }

}
