package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.service.adam.dto.AdamComInfoDto;
import com.liquidnet.service.adam.dto.AdamComInfoParam;
import com.liquidnet.service.adam.dto.query.AdamComInfoQuery;
import com.liquidnet.service.adam.entity.AdamComInfo;
import com.liquidnet.service.adam.mapper.AdamComInfoMapper;
import com.liquidnet.service.adam.service.IAdamComInfoService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;

/**
 * <p>
 * 公司信息 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-16
 */
@Service
public class AdamComInfoServiceImpl implements IAdamComInfoService {

    @Autowired
    private AdamComInfoMapper adamComInfoMapper;

    @Override
    public AdamComInfo selectById(String id) {
        return adamComInfoMapper.selectById(id);
    }

    @Override
    public int insert(AdamComInfoParam param) {
        AdamComInfo adamComInfo = new AdamComInfo();
        BeanUtils.copyProperties(param, adamComInfo);
        adamComInfo.setCreateTime(LocalDateTime.now());
        return adamComInfoMapper.insert(adamComInfo);
    }

    @Override
    public int updateById(AdamComInfoParam param) {
        AdamComInfo adamComInfo = new AdamComInfo();
        BeanUtils.copyProperties(param, adamComInfo);
        adamComInfo.setUpdateTime(LocalDateTime.now());
        return adamComInfoMapper.updateById(adamComInfo);
    }

    @Override
    public int update(AdamComInfoDto updateDto, AdamComInfoParam updateParam) {
        UpdateWrapper<AdamComInfo> updateWrapper = new UpdateWrapper<>();
        updateWrapper.lambda()
                .eq(AdamComInfo::getId, updateParam.getId())
                .eq(!StringUtils.isEmpty(updateParam.getState()),
                        AdamComInfo::getState, updateParam.getState());
        AdamComInfo adamComInfo = new AdamComInfo();
        BeanUtils.copyProperties(updateDto, adamComInfo);
        adamComInfo.setUpdateTime(LocalDateTime.now());
        return adamComInfoMapper.update(adamComInfo, updateWrapper);
    }

    @Override
    public Page<AdamComInfo> queryPageList(int pageNum, int pageSize, AdamComInfoQuery query) {
        QueryWrapper<AdamComInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .eq(!StringUtils.isEmpty(query.getComId()),
                        AdamComInfo::getId, query.getComId())
                .ge(!StringUtils.isEmpty(query.getCreatedTimeStart()),
                        AdamComInfo::getCreateTime, query.getCreatedTimeStart())
                .le(!StringUtils.isEmpty(query.getCreatedTimeEnd()),
                        AdamComInfo::getCreateTime, query.getCreatedTimeEnd())
                .orderByDesc(AdamComInfo::getCreateTime);
        return adamComInfoMapper.selectPage(new Page<>(pageNum, pageSize), queryWrapper);
    }

}
