package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.liquidnet.service.adam.dto.AdamComLegalPersonDto;
import com.liquidnet.service.adam.dto.AdamComLegalPersonParam;
import com.liquidnet.service.adam.entity.AdamComLegalPerson;
import com.liquidnet.service.adam.incrementer.CustomIdGenerator;
import com.liquidnet.service.adam.mapper.AdamComLegalPersonMapper;
import com.liquidnet.service.adam.service.IAdamComLegalPersonService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * <p>
 * 公司法人 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-25
 */
@Service
public class AdamComLegalPersonServiceImpl implements IAdamComLegalPersonService {

    @Autowired
    private AdamComLegalPersonMapper adamComLegalPersonMapper;

    @Autowired
    private CustomIdGenerator customIdGenerator;

    @Override
    public AdamComLegalPersonDto selectByComId(String comId) {
        QueryWrapper<AdamComLegalPerson> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(AdamComLegalPerson::getComId, comId);
        AdamComLegalPerson adamComLegalPerson = adamComLegalPersonMapper.selectOne(queryWrapper);
        AdamComLegalPersonDto dto = null;
        if (adamComLegalPerson != null) {
            dto = new AdamComLegalPersonDto();
            BeanUtils.copyProperties(adamComLegalPerson, dto);
        }
        return dto;
    }

    @Override
    public int insert(AdamComLegalPersonParam param) {
        AdamComLegalPerson adamComLegalPerson = new AdamComLegalPerson();
        BeanUtils.copyProperties(param, adamComLegalPerson);
        Long aLong = customIdGenerator.nextId(adamComLegalPerson);
        adamComLegalPerson.setId(String.valueOf(aLong));
        adamComLegalPerson.setCreateTime(LocalDateTime.now());
        return adamComLegalPersonMapper.insert(adamComLegalPerson);
    }

    @Override
    public int updateByComId(AdamComLegalPersonParam param) {
        AdamComLegalPerson adamComLegalPerson = new AdamComLegalPerson();
        BeanUtils.copyProperties(param, adamComLegalPerson);
        adamComLegalPerson.setUpdateTime(LocalDateTime.now());
        UpdateWrapper<AdamComLegalPerson> updateWrapper = new UpdateWrapper<>();
        updateWrapper.lambda().eq(AdamComLegalPerson::getComId, param.getComId());
        return adamComLegalPersonMapper.update(adamComLegalPerson, updateWrapper);
    }

}
