package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.liquidnet.service.adam.entity.AdamComProfile;
import com.liquidnet.service.adam.mapper.AdamComProfileMapper;
import com.liquidnet.service.adam.service.IAdamComProfileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class AdamComProfileServiceImpl extends ServiceImpl<AdamComProfileMapper, AdamComProfile> implements IAdamComProfileService {
    @Autowired
    private AdamComProfileMapper adamComProfileMapper;

    @Override
    public boolean initial(String comId) {
        // TODO: 2020/12/4 zhanggb:by template
        List<AdamComProfile> adamComProfileList = Lists.newArrayList(
                AdamComProfile.getNew().init(comId, "newWalletAssignToAllUser", "No", "When New Wallet is created, automatically add all existing users to access to the wallet?")
        );
        return this.saveBatch(adamComProfileList);
    }

    @Override
    public AdamComProfile query(String item, String comId) {
        LambdaQueryWrapper<AdamComProfile> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(AdamComProfile::getComId, comId)
                .eq(AdamComProfile::getItem, item);
        return adamComProfileMapper.selectOne(queryWrapper);
    }

    @Override
    public int updateByItem(String comId, String item, String itemVal) {
        LambdaUpdateWrapper<AdamComProfile> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(AdamComProfile::getComId, comId).eq(AdamComProfile::getItem, item);
        AdamComProfile updateEntity = new AdamComProfile();
        updateEntity.setItemVal(itemVal);
        return adamComProfileMapper.update(updateEntity, updateWrapper);
    }
}
