package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.liquidnet.service.adam.dto.AdamComShareholderParam;
import com.liquidnet.service.adam.entity.AdamComShareholder;
import com.liquidnet.service.adam.incrementer.CustomIdGenerator;
import com.liquidnet.service.adam.mapper.AdamComShareholderMapper;
import com.liquidnet.service.adam.service.IAdamComShareholderService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 公司股东信息 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-16
 */
@Service
public class AdamComShareholderServiceImpl implements IAdamComShareholderService {

    @Autowired
    private AdamComShareholderMapper adamComShareholderMapper;

    @Autowired
    private CustomIdGenerator customIdGenerator;

    @Override
    public List<AdamComShareholder> selectByComId(String comId) {
        QueryWrapper<AdamComShareholder> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(AdamComShareholder::getComId, comId);
        List<AdamComShareholder> studentList = adamComShareholderMapper.selectList(queryWrapper);
        return studentList;
    }

    @Override
    public AdamComShareholder selectOne(String comId, String position) {
        QueryWrapper<AdamComShareholder> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(AdamComShareholder::getComId, comId).eq(AdamComShareholder::getPosition, position);
        return adamComShareholderMapper.selectOne(queryWrapper);

    }

    @Override
    public int insert(AdamComShareholderParam param) {
        AdamComShareholder adamComShareholder = new AdamComShareholder();
        BeanUtils.copyProperties(param, adamComShareholder);
        Long aLong = customIdGenerator.nextId(adamComShareholder);
        adamComShareholder.setId(String.valueOf(aLong));
        adamComShareholder.setCreateTime(LocalDateTime.now());
        return adamComShareholderMapper.insert(adamComShareholder);
    }

    @Override
    public int updateByComId(AdamComShareholderParam param) {
        UpdateWrapper<AdamComShareholder> updateWrapper = new UpdateWrapper<>();
        updateWrapper.lambda().
                eq(AdamComShareholder::getComId, param.getComId()).
                eq(AdamComShareholder::getPosition, param.getPosition());
        AdamComShareholder adamComShareholder = new AdamComShareholder();
        BeanUtils.copyProperties(param, adamComShareholder);
        adamComShareholder.setUpdateTime(LocalDateTime.now());
        return adamComShareholderMapper.update(adamComShareholder, updateWrapper);
    }

}
