package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.liquidnet.service.adam.constant.AdamPayerConstants;
import com.liquidnet.service.adam.entity.AdamConversion;
import com.liquidnet.service.adam.entity.AdamPayer;
import com.liquidnet.service.adam.mapper.AdamConversionMapper;
import com.liquidnet.service.adam.service.IAdamConversionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/**
 * <p>
 * 换汇 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2020-11-10
 */
@Service
public class AdamConversionServiceImpl implements IAdamConversionService {

    @Autowired
    private AdamConversionMapper adamConversionMapper;

    @Override
    public int insert(AdamConversion conversion) {
        return adamConversionMapper.insert(conversion);
    }

    @Override
    public int updateById(AdamConversion conversion) {
        return adamConversionMapper.updateById(conversion);
    }

    @Override
    public AdamConversion selectById(String id) {
        return adamConversionMapper.selectById(id);
    }

    @Override
    public AdamConversion selectOne(AdamConversion param) {
        QueryWrapper<AdamConversion> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .eq(!StringUtils.isEmpty(param.getId()), AdamConversion::getId, param.getId())
                .eq(!StringUtils.isEmpty(param.getComId()), AdamConversion::getComId, param.getComId())
                .eq(!StringUtils.isEmpty(param.getBankConversionId()), AdamConversion::getBankConversionId, param.getBankConversionId())
        ;
        return adamConversionMapper.selectOne(queryWrapper);
    }

}
