package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.liquidnet.service.adam.entity.AdamFunding;
import com.liquidnet.service.adam.mapper.AdamFundingMapper;
import com.liquidnet.service.adam.service.IAdamFundingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;

/**
 * <p>
 * 充值信息表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-30
 */
@Service
public class AdamFundingServiceImpl implements IAdamFundingService {

    @Autowired
    private AdamFundingMapper adamFundingMapper;

    @Override
    public int updateById(AdamFunding param) {
        param.setUpdateTime(LocalDateTime.now());
        return adamFundingMapper.updateById(param);
    }

    @Override
    public int insert(AdamFunding param) {
        param.setCreateTime(LocalDateTime.now());
        return adamFundingMapper.insert(param);
    }

    @Override
    public AdamFunding selectOne(AdamFunding param) {

        QueryWrapper<AdamFunding> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .eq(!StringUtils.isEmpty(param.getId()), AdamFunding::getId, param.getId())
                .eq(!StringUtils.isEmpty(param.getComId()), AdamFunding::getComId, param.getComId())
                .eq(!StringUtils.isEmpty(param.getStatus()), AdamFunding::getStatus, param.getStatus())
                .eq(!StringUtils.isEmpty(param.getCurrency()), AdamFunding::getCurrency, param.getCurrency())
                .eq(!StringUtils.isEmpty(param.getBankChannel()), AdamFunding::getBankChannel, param.getBankChannel())
                .eq(!StringUtils.isEmpty(param.getBankFundingId()), AdamFunding::getBankFundingId, param.getBankFundingId())
                .eq(!StringUtils.isEmpty(param.getFinWalletNo()), AdamFunding::getFinWalletNo, param.getFinWalletNo())
        ;
        return adamFundingMapper.selectOne(queryWrapper);

    }

}
