package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.adam.biz.AdamUserLoginBiz;
import com.liquidnet.service.adam.entity.AdamLoginOnline;
import com.liquidnet.service.adam.mapper.AdamLoginOnlineMapper;
import com.liquidnet.service.adam.service.IAdamLoginOnlineService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 在线用户记录 服务实现类
 * </p>
 *
 * @author AnJiabin
 * @since 2020-11-23
 */
@Slf4j
@Service
public class AdamLoginOnlineServiceImpl extends ServiceImpl<AdamLoginOnlineMapper, AdamLoginOnline> implements IAdamLoginOnlineService {
    @Autowired
    private AdamLoginOnlineMapper adamLoginOnlineMapper;

    

    /**
     * 通过会话序号查询信息
     *
     * @param userId 会用户id
     * @return 在线用户信息
     */
    @Override
    public AdamLoginOnline selectOnlineByUserId(String userId)
    {
        LambdaQueryWrapper<AdamLoginOnline> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(!StringUtils.isEmpty(userId),AdamLoginOnline::getUserId,userId);
        return adamLoginOnlineMapper.selectOne(wrapper);
    }

    /**
     * 通过会话序号查询信息
     *
     * @param sessionId 会话ID
     * @return 在线用户信息
     */
    @Override
    public AdamLoginOnline selectOnlineBySessionId(String sessionId)
    {
        LambdaQueryWrapper<AdamLoginOnline> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(!StringUtils.isEmpty(sessionId),AdamLoginOnline::getSessionId,sessionId);
        return adamLoginOnlineMapper.selectOne(wrapper);
    }

    /**
     * 通过会话序号删除信息
     *
     * @param userId 用户id
     * @return 在线用户信息
     */
    @Override
    public void deleteOnlineByUserId(String userId)
    {
        if (StringUtil.isNotNull(userId))
        {
            LambdaQueryWrapper<AdamLoginOnline> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(!StringUtils.isEmpty(userId),AdamLoginOnline::getUserId,userId);
            adamLoginOnlineMapper.delete(wrapper);
        }
    }

    @Override
    public void deleteOnlineBySessionId(String sessionId)
    {
        if (StringUtil.isNotNull(sessionId))
        {
            LambdaQueryWrapper<AdamLoginOnline> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(!StringUtils.isEmpty(sessionId),AdamLoginOnline::getSessionId,sessionId);
            adamLoginOnlineMapper.delete(wrapper);
        }
    }

    /**
     * 通过会话序号删除信息
     *
     * @param sessions 会话ID集合
     * @return 在线用户信息
     */
    @Override
    public void batchDeleteOnline(List<String> sessions)
    {
        for (String sessionId : sessions)
        {
            AdamLoginOnline userOnline = selectOnlineBySessionId(sessionId);
            if (StringUtil.isNotNull(userOnline))
            {
                adamLoginOnlineMapper.deleteById(sessionId);
            }
        }
    }

    /**
     * 保存会话信息
     *
     * @param online 会话信息
     */
    @Override
    public void saveOnline(AdamLoginOnline online)
    {
        adamLoginOnlineMapper.insert(online);
    }

    /**
     * 查询会话集合
     *
     * @param userOnline 在线用户
     */
    @Override
    public List<AdamLoginOnline> selectUserOnlineList(AdamLoginOnline userOnline)
    {
        QueryWrapper queryWrapper = new QueryWrapper();

        return adamLoginOnlineMapper.selectList(queryWrapper);
    }

    /**
     * 查询会话集合
     *
     * @param expiredDate 失效日期
     */
    @Override
    public List<AdamLoginOnline> selectOnlineByExpired(Date expiredDate)
    {
        String lastAccessTime = DateUtil.format(expiredDate, DateUtil.Formatter.yyyyMMddHHmmss);
        LambdaQueryWrapper<AdamLoginOnline> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(!StringUtils.isEmpty( lastAccessTime),AdamLoginOnline::getExpireTime, lastAccessTime);
        return adamLoginOnlineMapper.selectList(wrapper);
    }
}
