package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.liquidnet.service.adam.entity.AdamPayout;
import com.liquidnet.service.adam.mapper.AdamPayoutMapper;
import com.liquidnet.service.adam.service.IAdamPayoutService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

@Slf4j
@Service
public class AdamPayoutServiceImpl implements IAdamPayoutService {

    @Autowired
    AdamPayoutMapper adamPayoutMapper;

    @Override
    public AdamPayout selectById(String id, String comId) {
        LambdaQueryWrapper<AdamPayout> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(AdamPayout::getId, id).eq(AdamPayout::getComId, comId);
        return adamPayoutMapper.selectOne(queryWrapper);
    }

    @Override
    public AdamPayout selectById(String id) {
        return adamPayoutMapper.selectById(id);
    }

    @Override
    public int updateById(AdamPayout adamPayout) {
        adamPayout.setUpdateTime(LocalDateTime.now());
        return adamPayoutMapper.updateById(adamPayout);

    }

}
