package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.liquidnet.service.adam.entity.AdamRolePermission;
import com.liquidnet.service.adam.mapper.AdamRolePermissionMapper;
import com.liquidnet.service.adam.service.IAdamRolePermissionService;
import com.liquidnet.service.adam.vo.AdamPermissionInfoVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class AdamRolePermissionServiceImpl implements IAdamRolePermissionService {
    @Autowired
    private AdamRolePermissionMapper adamRolePermissionMapper;

    @Override
    public Map<String, List<AdamPermissionInfoVo>> queryRolePermissions() {
        List<AdamPermissionInfoVo> targetList = Lists.newArrayList();

        LambdaQueryWrapper<AdamRolePermission> queryWrapper = new LambdaQueryWrapper<>();
        List<AdamRolePermission> rolePermissionList = adamRolePermissionMapper.selectList(queryWrapper);

        rolePermissionList.forEach(r -> {
            targetList.add(AdamPermissionInfoVo.getNew().copy(r));
        });

        return targetList.stream().collect(Collectors.groupingBy(AdamPermissionInfoVo::getRoleId));
    }

    @Override
    public List<AdamRolePermission> queryRolePermissions(String roleId) {
        LambdaQueryWrapper<AdamRolePermission> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(AdamRolePermission::getRoleId, roleId);
        return adamRolePermissionMapper.selectList(queryWrapper);
    }
}
