package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.liquidnet.service.adam.entity.AdamRole;
import com.liquidnet.service.adam.mapper.AdamRoleMapper;
import com.liquidnet.service.adam.service.IAdamRoleService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Service
public class AdamRoleServiceImpl implements IAdamRoleService {
    @Autowired
    private AdamRoleMapper adamRoleMapper;

    @Override
    public Map<String, String> query() {
        LambdaQueryWrapper<AdamRole> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(AdamRole::getDelFlag, "1").eq(AdamRole::getRoleStatus, "1");
        List<AdamRole> roleList = adamRoleMapper.selectList(queryWrapper);
        return roleList.stream().collect(Collectors.toMap(AdamRole::getRoleId, AdamRole::getRoleName));
    }

    @Override
    public String queryRoleId(String roleName) {
        LambdaQueryWrapper<AdamRole> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(AdamRole::getDelFlag, "1").eq(AdamRole::getRoleStatus, "1").eq(AdamRole::getRoleName, roleName);
        List<AdamRole> roleList = adamRoleMapper.selectList(queryWrapper);
        return CollectionUtils.isEmpty(roleList) ? null : roleList.get(0).getRoleId();
    }
}
