package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.liquidnet.service.adam.entity.AdamSysCountryProvince;
import com.liquidnet.service.adam.mapper.AdamSysCountryProvinceMapper;
import com.liquidnet.service.adam.service.IAdamSysCountryProvinceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * <p>
 * 国家州/省 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-22
 */
@Service
public class AdamSysCountryProvinceServiceImpl implements IAdamSysCountryProvinceService {

    @Autowired
    AdamSysCountryProvinceMapper sysCountryProvinceMapper;

    @Override
    public List<AdamSysCountryProvince> selectList(String countryCode) {

        QueryWrapper<AdamSysCountryProvince> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .eq(!StringUtils.isEmpty(countryCode), AdamSysCountryProvince::getCountryCode, countryCode)
                .orderByAsc(AdamSysCountryProvince::getProvinceCode);

        return sysCountryProvinceMapper.selectList(queryWrapper);
    }

}
