package com.liquidnet.service.adam.service.impl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.liquidnet.service.adam.entity.AdamSysCountry;
import com.liquidnet.service.adam.mapper.AdamSysCountryMapper;
import com.liquidnet.service.adam.service.IAdamSysCountryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 国家表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-24
 */
@Service
public class AdamSysCountryServiceImpl implements IAdamSysCountryService {

    @Autowired
    AdamSysCountryMapper adamSysCountryMapper;

    @Override
    public List<AdamSysCountry> selectList(AdamSysCountry country) {
        if (country == null) {
            country = new AdamSysCountry();
        }
        QueryWrapper<AdamSysCountry> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .eq(!StringUtils.isEmpty(country.getCode()), AdamSysCountry::getCode, country.getCode())
                .eq(!StringUtils.isEmpty(country.getCurrencyAlphabeticCode()), AdamSysCountry::getCurrencyAlphabeticCode, country.getCurrencyAlphabeticCode())
                .orderByAsc(AdamSysCountry::getCode);

        return adamSysCountryMapper.selectList(queryWrapper);
    }

    @Override
    public AdamSysCountry selectByCurrency(String currency) {
        QueryWrapper<AdamSysCountry> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(AdamSysCountry::getCurrencyAlphabeticCode, currency);
        return adamSysCountryMapper.selectOne(queryWrapper);
    }

    @Override
    public BigDecimal accuracy(BigDecimal amount, String currency) {
        AdamSysCountry adamSysCountry = this.selectByCurrency(currency);
        if (adamSysCountry == null) {
            return amount;
        }

        return amount.setScale(Integer.parseInt(adamSysCountry.getCurrencyMinorUnit()), BigDecimal.ROUND_DOWN);
    }

}
