package com.liquidnet.service.adam.service.impl;
import com.liquidnet.service.adam.entity.*;
import com.liquidnet.service.adam.mapper.*;
import com.liquidnet.service.adam.vo.AdamPayoutVo;
import com.liquidnet.service.adam.vo.AdamPayoutPayerVo;
import com.liquidnet.service.adam.vo.AdamPayoutBeneficiaryVo;
import com.liquidnet.service.adam.vo.AdamTransactionVo;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.liquidnet.service.adam.dto.*;
import com.liquidnet.service.adam.dto.query.AdamTransactionQuery;
import com.liquidnet.service.adam.service.IAdamTransactionService;
import com.liquidnet.service.adam.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 交易记录表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-30
 */
@Service
public class AdamTransactionServiceImpl implements IAdamTransactionService {

    @Autowired
    private AdamTransactionMapper adamTransactionMapper;

    @Autowired
    private AdamFundingMapper adamFundingMapper;

    @Autowired
    private AdamPayoutMapper adamPayoutMapper;

    @Autowired
    private AdamPayoutBeneficiaryMapper adamPayoutBeneficiaryMapper;

    @Autowired
    private AdamPayoutPayerMapper adamPayoutPayerMapper;

    @Autowired
    private AdamConversionMapper adamConversionMapper;

    @Override
    public int updateById(AdamTransaction adamTransaction) {
        adamTransaction.setUpdateTime(LocalDateTime.now());
        return adamTransactionMapper.updateById(adamTransaction);
    }

    @Override
    public int insert(AdamTransaction param) {
        return adamTransactionMapper.insert(param);
    }

    @Override
    public AdamTransaction selectById(String id) {
        return adamTransactionMapper.selectById(id);
    }

    @Override
    public AdamTransaction selectOne(AdamTransactionParam param) {
        QueryWrapper<AdamTransaction> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .eq(!StringUtils.isEmpty(param.getId()), AdamTransaction::getId, param.getId())
                .eq(!StringUtils.isEmpty(param.getRelatedId()), AdamTransaction::getRelatedId, param.getRelatedId())
                .eq(!StringUtils.isEmpty(param.getComId()), AdamTransaction::getComId, param.getComId())
                .eq(!StringUtils.isEmpty(param.getType()), AdamTransaction::getType, param.getType())
                .eq(!StringUtils.isEmpty(param.getStatus()), AdamTransaction::getStatus, param.getStatus())
                .eq(!StringUtils.isEmpty(param.getCurrency()), AdamTransaction::getCurrency, param.getCurrency())
                .eq(!StringUtils.isEmpty(param.getBankTransactionId()), AdamTransaction::getBankTransactionId, param.getBankTransactionId())
                .eq(!StringUtils.isEmpty(param.getBankChannel()), AdamTransaction::getBankChannel, param.getBankChannel())
                .eq(!StringUtils.isEmpty(param.getFinWalletNo()), AdamTransaction::getFinWalletNo, param.getFinWalletNo())
                .eq(!StringUtils.isEmpty(param.getFinWalletTransactionId()), AdamTransaction::getFinWalletTransactionId, param.getFinWalletTransactionId())
        ;
        return adamTransactionMapper.selectOne(queryWrapper);
    }

    @Override
    public List<AdamTransaction> selectList(AdamTransactionParam param) {
        QueryWrapper<AdamTransaction> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .eq(!StringUtils.isEmpty(param.getId()), AdamTransaction::getId, param.getId())
                .eq(!StringUtils.isEmpty(param.getRelatedId()), AdamTransaction::getRelatedId, param.getRelatedId())
                .eq(!StringUtils.isEmpty(param.getComId()), AdamTransaction::getComId, param.getComId())
                .eq(!StringUtils.isEmpty(param.getType()), AdamTransaction::getType, param.getType())
                .eq(!StringUtils.isEmpty(param.getStatus()), AdamTransaction::getStatus, param.getStatus())
                .eq(!StringUtils.isEmpty(param.getCurrency()), AdamTransaction::getCurrency, param.getCurrency())
                .eq(!StringUtils.isEmpty(param.getBankTransactionId()), AdamTransaction::getBankTransactionId, param.getBankTransactionId())
                .eq(!StringUtils.isEmpty(param.getBankChannel()), AdamTransaction::getBankChannel, param.getBankChannel())
                .eq(!StringUtils.isEmpty(param.getFinWalletNo()), AdamTransaction::getFinWalletNo, param.getFinWalletNo())
                .eq(!StringUtils.isEmpty(param.getFinWalletTransactionId()), AdamTransaction::getFinWalletTransactionId, param.getFinWalletTransactionId())
        ;
        return adamTransactionMapper.selectList(queryWrapper);
    }

    @Override
    public Page<AdamTransaction> queryPageList(int pageNum, int pageSize, AdamTransactionQuery queryParam) {
        QueryWrapper<AdamTransaction> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .eq(!StringUtils.isEmpty(queryParam.getComId()), AdamTransaction::getComId, queryParam.getComId())
                .eq(!StringUtils.isEmpty(queryParam.getFinWalletNo()), AdamTransaction::getFinWalletNo, queryParam.getFinWalletNo())
                .eq(!StringUtils.isEmpty(queryParam.getStatus()), AdamTransaction::getStatus, queryParam.getStatus())
                .eq(!StringUtils.isEmpty(queryParam.getCurrency()), AdamTransaction::getCurrency, queryParam.getCurrency())
                .eq(!StringUtils.isEmpty(queryParam.getType()), AdamTransaction::getType, queryParam.getType())
                .eq(!StringUtils.isEmpty(queryParam.getFundDirection()), AdamTransaction::getFundDirection, queryParam.getFundDirection())

                .ge(!StringUtils.isEmpty(queryParam.getCreateDateFrom()), AdamTransaction::getCreateTime, queryParam.getCreateDateFrom())
                .le(!StringUtils.isEmpty(queryParam.getCreateDateTo()), AdamTransaction::getCreateTime, queryParam.getCreateDateTo())

                .ge(!StringUtils.isEmpty(queryParam.getCompleteDateFrom()), AdamTransaction::getCompleteTime, queryParam.getCompleteDateFrom())
                .le(!StringUtils.isEmpty(queryParam.getCompleteDateTo()), AdamTransaction::getCompleteTime, queryParam.getCompleteDateTo())

                .like(!StringUtils.isEmpty(queryParam.getNumber()), AdamTransaction::getNumber, queryParam.getNumber())
                .like(!StringUtils.isEmpty(queryParam.getReference()), AdamTransaction::getRelatedReference, queryParam.getReference())
                .orderByDesc(AdamTransaction::getCreateTime);
        Page<AdamTransaction> adamTransactionPage = adamTransactionMapper.selectPage(new Page<>(pageNum, pageSize), queryWrapper);
        return adamTransactionPage;
    }

    @Override
    public AdamFundingDetailVo getFundingDetail(String comId, String transactionId) {
        AdamFundingDetailVo vo = new AdamFundingDetailVo();

        AdamTransactionVo transactionVo = getTransactionVo(comId, transactionId);
        if (transactionVo == null) {
            return null;
        }
        QueryWrapper<AdamFunding> query = new QueryWrapper<>();
        query.lambda().eq(AdamFunding::getId, transactionVo.getRelatedId());
        AdamFunding adamFunding = adamFundingMapper.selectOne(query);
        if (adamFunding == null) {
            return null;
        }

        AdamFundingVo fundingVo = new AdamFundingVo();
        fundingVo.conversion(adamFunding);
        vo.setTransactionVo(transactionVo);
        vo.setFundingVo(fundingVo);
        return vo;
    }

    @Override
    public AdamPayoutDetailVo getPayoutDetail(String comId, String transactionId) {
        AdamTransactionVo transactionVo = getTransactionVo(comId, transactionId);
        if (transactionVo == null) {
            return null;
        }
        String payoutId = transactionVo.getRelatedId();
        AdamPayout adamPayout = adamPayoutMapper.selectById(payoutId);
        AdamPayoutVo adamPayoutVo = new AdamPayoutVo();
        adamPayoutVo.conversion(adamPayout);

        AdamPayoutPayer payoutPayer = adamPayoutPayerMapper.selectById(payoutId);
        AdamPayoutPayerVo payoutPayerVo = new AdamPayoutPayerVo();
        payoutPayerVo.conversion(payoutPayer);

        AdamPayoutBeneficiary payoutBeneficiary = adamPayoutBeneficiaryMapper.selectById(payoutId);
        AdamPayoutBeneficiaryVo payoutBeneficiaryVo = new AdamPayoutBeneficiaryVo();
        payoutBeneficiaryVo.conversion(payoutBeneficiary);

        AdamPayoutDetailVo adamPayoutDetailVo = new AdamPayoutDetailVo();
        adamPayoutDetailVo.setPayoutVo(adamPayoutVo);
        adamPayoutDetailVo.setPayoutPayerVo(payoutPayerVo);
        adamPayoutDetailVo.setPayoutBeneficiaryVo(payoutBeneficiaryVo);
        adamPayoutDetailVo.setTransactionVo(transactionVo);
        return adamPayoutDetailVo;
    }

    @Override
    public AdamConversionDetailVo getConversionDetail(String comId, String transactionId) {
        AdamConversionDetailVo vo = new AdamConversionDetailVo();
        AdamTransactionVo transactionVo = getTransactionVo(comId, transactionId);
        if (transactionVo == null) {
            return null;
        }
        QueryWrapper<AdamConversion> query = new QueryWrapper<>();
        query.lambda().eq(AdamConversion::getId, transactionVo.getRelatedId());
        AdamConversion conversion = adamConversionMapper.selectOne(query);
        if (conversion == null) {
            return null;
        }
        AdamConversionVo conversionVo = new AdamConversionVo();
        conversionVo.conversion(conversion);
        vo.setTransactionVo(transactionVo);
        vo.setConversionVo(conversionVo);
        return vo;
    }

    /**
     * 查询交易
     *
     * @param comId         公司id
     * @param transactionId 交易id
     */
    private AdamTransactionVo getTransactionVo(String comId, String transactionId) {
        QueryWrapper<AdamTransaction> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .eq(AdamTransaction::getId, transactionId)
                .eq(AdamTransaction::getComId, comId)
        ;
        AdamTransaction adamTransaction = adamTransactionMapper.selectOne(queryWrapper);
        if (adamTransaction == null) {
            return null;
        }
        AdamTransactionVo transactionVo = new AdamTransactionVo();
        transactionVo.conversion(adamTransaction);
        return transactionVo;
    }

}
