package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.liquidnet.service.adam.constant.AdamUserConstants;
import com.liquidnet.service.adam.entity.AdamUserAuthLog;
import com.liquidnet.service.adam.mapper.AdamUserAuthLogMapper;
import com.liquidnet.service.adam.service.IAdamUserAuthLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * <p>
 *  用户认证记录 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2020-09-16
 */
@Service
public class AdamUserAuthLogServiceImpl implements IAdamUserAuthLogService {

    @Autowired
    private AdamUserAuthLogMapper adamUserAuthLogMapper;

    @Override
    public int insert(AdamUserAuthLog log) {
        log.setCreateTime(LocalDateTime.now());
        log.setUpdateTime(LocalDateTime.now());
        return adamUserAuthLogMapper.insert(log);
    }

    @Override
    public AdamUserAuthLog getUserAuthLog(String userId, AdamUserConstants.UserAuthTypeEnum typeEnum) {
        QueryWrapper<AdamUserAuthLog> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("user_id", userId);
        queryWrapper.eq("auth_type", typeEnum.name());
        return adamUserAuthLogMapper.selectOne(queryWrapper);
    }

    @Override
    public int updateById(AdamUserAuthLog adamUserAuthLog) {
        return adamUserAuthLogMapper.updateById(adamUserAuthLog);
    }

    @Override
    public int update(UpdateWrapper<AdamUserAuthLog> updateWrapper) {
        return adamUserAuthLogMapper.update(null, updateWrapper);
    }
}
