package com.liquidnet.service.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.liquidnet.service.adam.entity.AdamRolePermission;
import com.liquidnet.service.adam.entity.AdamUserPermission;
import com.liquidnet.service.adam.mapper.AdamUserPermissionMapper;
import com.liquidnet.service.adam.service.IAdamRolePermissionService;
import com.liquidnet.service.adam.service.IAdamRoleService;
import com.liquidnet.service.adam.service.IAdamUserPermissionService;
import com.liquidnet.service.adam.vo.AdamPermissionInfoVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Service
public class AdamUserPermissionServiceImpl extends ServiceImpl<AdamUserPermissionMapper, AdamUserPermission> implements IAdamUserPermissionService {
    @Autowired
    private AdamUserPermissionMapper adamUserPermissionMapper;
    @Autowired
    private IAdamRolePermissionService adamRolePermissionService;
    @Autowired
    private IAdamRoleService adamRoleService;

    //    @Override
    public int removeByUserId(String userId) {
        Map<String, Object> map = Maps.newHashMap();
        map.put("user_id", userId);
        return adamUserPermissionMapper.deleteByMap(map);
    }

    @Override
    public List<AdamUserPermission> query(String userId) {
        LambdaQueryWrapper<AdamUserPermission> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.select(AdamUserPermission::getAuthId).eq(AdamUserPermission::getUserId, userId);
        return adamUserPermissionMapper.selectList(queryWrapper);
    }

    @Override
    public List<String> queryPermissionKeyByUserId(String userId) {
        List<AdamUserPermission> adamUserPermissionList = this.query(userId);
        return adamUserPermissionList.stream().map(AdamUserPermission::getAuthId).collect(Collectors.toList());
    }

    @Override
    public List<AdamPermissionInfoVo> queryPermissionByUserId(String userId) {
        List<AdamPermissionInfoVo> targetList = Lists.newArrayList();
        List<AdamUserPermission> adamUserPermissionList = this.query(userId);
        adamUserPermissionList.forEach(r -> {
            targetList.add(AdamPermissionInfoVo.getNew().copy(r));
        });
        return targetList;
    }

    @Override
    public boolean assignPermissions(String userId, String comId, String roleName) {
        String roleId = adamRoleService.queryRoleId(roleName);
        List<AdamRolePermission> rolePermissionList = adamRolePermissionService.queryRolePermissions(roleId);
        List<AdamRolePermission> assignRolePermissionList = rolePermissionList.stream().filter(r -> r.getExecutable().equals("1")).collect(Collectors.toList());
        return this.savePermissions(assignRolePermissionList, userId, comId, roleId);
    }

    @Override
    public boolean savePermissions(List<AdamRolePermission> assignRolePermissionList, String userId, String comId, String roleId) {
        this.removeByUserId(userId);

        List<AdamUserPermission> assignUserPermissionList = Lists.newArrayList();
        assignRolePermissionList.forEach(r -> {
            AdamUserPermission newObj = AdamUserPermission.getNew().copy(r);
            newObj.setUserId(userId);
            newObj.setComId(comId);
            newObj.setRoleId(roleId);
            assignUserPermissionList.add(newObj);
        });

        return this.saveBatch(assignUserPermissionList);
    }
}
