package com.liquidnet.service.adam.service.sys;
import com.liquidnet.service.adam.common.EmailEntity;
import com.liquidnet.service.adam.util.EmailUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 账户 异步服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2020-10-13
 */
@Service
@Slf4j
public class AdamSysEmailServiceImpl implements IAdamSysEmailService {

    @Autowired
    EmailUtil emailUtil;

    @Override
    @Async
    public void asyncSendEmail(String to, String msg, String title) {
        // todo-lichen 未完成,邮件实现是谷歌免费邮件服务
        try {
            EmailEntity emailEntity = new EmailEntity();
            emailEntity.setFromPerson("Liquid Net");
            emailEntity.setToPerson(to);
            emailEntity.setTargetMail(to);
            emailEntity.setContent(msg);
            emailEntity.setSubject(title);
            log.info("邮件内容" + emailEntity.getContent());
            emailUtil.doSendMsg(emailEntity);
        } catch (Exception e) {

            log.error("邮件异常", e);
        }
    }

}
