package com.liquidnet.service.adam.service.sys;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class AdamSystemlServiceImpl implements IAdamSystemService {

    @Value("${spring.profiles.active}")
    private String springProfilesActive;

    @Override
    public String generateVerifyCode() {
        String confirmCode = "888888";
        if ("prod".equals(springProfilesActive)) {
            confirmCode = String.valueOf((int) (Math.random() * 900000 + 100000));
        }
        return confirmCode;
    }

    @Override
    public int conversionPdfPageSize() {
        int size = 2;
        if ("prod".equals(springProfilesActive)) {
            size = 100;
        }
        return size;
    }

}
