package com.liquidnet.service.adam.util;
import com.liquidnet.common.cache.redisson.util.RedisLockUtil;
import com.liquidnet.service.adam.constant.AdamRedisConstants;
import org.redisson.api.RLock;

import java.util.concurrent.TimeUnit;

/**
 * @author Li Chen
 * @date 2020-11-04 18:33
 */
public class AdamRedisLockUtil {

    /**
     * 加锁
     */
    public static RLock lock(String lockKey) {
        return RedisLockUtil.lock(lockKey);
    }

    /**
     * 尝试获取锁
     *
     * @param waitTime  最多等待时间
     * @param leaseTime 上锁后自动释放锁时间
     */
    public static boolean tryLock(String lockKey, int waitTime, int leaseTime) {
        return RedisLockUtil.tryLock(lockKey, TimeUnit.SECONDS, waitTime, leaseTime);
    }

    /**
     * 释放锁
     */
    public static void unlock(String lockKey) {
        RedisLockUtil.unlock(lockKey);
    }

}
