package com.liquidnet.service.adam.service;

import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.ResponseDto;
import com.liquidnet.service.adam.service.sys.AdamSysMongoServiceImpl;
import com.mongodb.*;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSFindIterable;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.test.context.junit4.SpringRunner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.List;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description:
 * @class: MongodbSslTest
 * @Package com.liquidnet.service.adam.service
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/12/18 2:17 下午
 */
@SpringBootTest
@RunWith(SpringRunner.class)
public class MongodbSslNewTest {
    @Autowired
    private GridFsTemplate gridFsTemplate;

    @Autowired
    private MongoClient mongoClient;

    @Autowired
    private AdamSysMongoServiceImpl adamSysMongoService;
    @Test
    public void test() throws FileNotFoundException {



        ObjectId store = gridFsTemplate.store(new FileInputStream(new File("/Users/anjiabin/myproject/certs/mongodb-mac.sh")), "123.sh");
        System.out.println(store);


//        GridFSFindIterable gridFSFindIterable = gridFsTemplate.find(new Query());
//        System.out.println(JsonUtils.obj2Json(gridFSFindIterable));


//        GridFSFindIterable id = gridFsTemplate.find(Query.query(Criteria.where("_id").is("ObjectId(\"5fdb372b6832f5e29a3aaa0d\")")));
//
//        System.out.println(JsonUtils.obj2Json(id));
//
//        String truststore = "/Users/anjiabin/myproject/certs/rds-truststore.jks";///rds-truststore.jks
//        String truststorePassword = "LiquidNet!@#4";
//
//        System.setProperty("javax.net.ssl.trustStore", truststore);
//        System.setProperty("javax.net.ssl.trustStorePassword", truststorePassword);
//
//        MongoDatabase testDB = mongoClient.getDatabase("liquidnet_mgdb");
//        MongoCollection<Document> numbersCollection = testDB.getCollection("test");
//
//        Document doc = new Document("name", "pi").append("value", 3.14159);
//        numbersCollection.insertOne(doc);
//
//        MongoCursor<Document> cursor = numbersCollection.find().iterator();
//        try {
//            while (cursor.hasNext()) {
//                System.out.println(cursor.next().toJson());
//            }
//        } finally {
//            cursor.close();
//        }

    }

    @Test
    public void testMmongoClient() throws FileNotFoundException {
//        String truststore = "/Users/anjiabin/myproject/certs/rds-truststore.jks";///rds-truststore.jks
//        String truststorePassword = "LiquidNet!@#4";
//
//        System.setProperty("javax.net.ssl.trustStore", truststore);
//        System.setProperty("javax.net.ssl.trustStorePassword", truststorePassword);

        MongoDatabase testDB = mongoClient.getDatabase("liquidnet_mgdb");
        MongoCollection<Document> numbersCollection = testDB.getCollection("test");

        Document doc = new Document("name", "pi").append("value", 3.14159);
        numbersCollection.insertOne(doc);

        MongoCursor<Document> cursor = numbersCollection.find().iterator();
        try {
            while (cursor.hasNext()) {
                System.out.println(cursor.next().toJson());
            }
        } finally {
            cursor.close();
        }

    }
}
