package com.liquidnet.service.adam.service;

import com.mongodb.*;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import org.bson.Document;

import java.util.Collections;
import java.util.List;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description:
 * @class: MongodbSslTest
 * @Package com.liquidnet.service.adam.service
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/12/18 2:17 下午
 */
//@SpringBootTest
//@RunWith(SpringRunner.class)
public class MongodbSslTest {
    @Test
    public void test(){
//        String template = "mongodb://%s:%s@%s/liquidnet_mgdb?ssl=true&replicaSet=rs0&readpreference=%s&retryWrites=false&ssl_ca_certs=/Users/anjiabin/Downloads/rds-combined-ca-bundle.pem";
        String template = "mongodb://%s:%s@%s/liquidnet_mgdb?ssl=true&replicaSet=rs0&readpreference=%s&retryWrites=false&ssl_ca_certs=/Users/anjiabin/Downloads/rds-combined-ca-bundle2.pem";
        String username = "smartnet";
        String password = "a43ljKmK8oqdOO902P";
        String clusterEndpoint = "smartnet-nonprod-docdb-docdb.cluster-cgjsqu7tuka2.ap-southeast-1.docdb.amazonaws.com:27017";
//        String clusterEndpoint = "sample-cluster.node.us-east-1.docdb.amazonaws.com:27017";
        String readPreference = "secondaryPreferred";
        String connectionString = String.format(template, username, password, clusterEndpoint, readPreference);

        String truststore = "/Users/anjiabin/myproject/certs/rds-truststore.jks";///rds-truststore.jks
        String truststorePassword = "LiquidNet!@#4";

        System.setProperty("javax.net.ssl.trustStore", truststore);
        System.setProperty("javax.net.ssl.trustStorePassword", truststorePassword);

        MongoClientURI clientURI = new MongoClientURI(connectionString);
        MongoClient mongoClient = new MongoClient(clientURI);

        MongoDatabase testDB = mongoClient.getDatabase("liquidnet_mgdb");
        MongoCollection<Document> numbersCollection = testDB.getCollection("test");

        Document doc = new Document("name", "pi").append("value", 3.14159);
        numbersCollection.insertOne(doc);

        MongoCursor<Document> cursor = numbersCollection.find().iterator();
        try {
            while (cursor.hasNext()) {
                System.out.println(cursor.next().toJson());
            }
        } finally {
            cursor.close();
        }
    }

    @Test
    public void test22(){
        //properties 对象为springboot创建，可直接用
        String username = "smartnet";
        String database = "liquidnet_mgdb";
        String password = "a43ljKmK8oqdOO902P";
        MongoCredential credentials = MongoCredential.createCredential(username, database, password.toCharArray());
        String host = "smartnet-nonprod-docdb-docdb.cluster-cgjsqu7tuka2.ap-southeast-1.docdb.amazonaws.com";
        int port = 27017;
        List<ServerAddress> addrs = Collections.singletonList(new ServerAddress(host, port));

        String truststore = "/Users/anjiabin/myproject/certs/rds-truststore.jks";///rds-truststore.jks
        String truststorePassword = "LiquidNet!@#4";

        System.setProperty("javax.net.ssl.trustStore", truststore);
        System.setProperty("javax.net.ssl.trustStorePassword", truststorePassword);

        MongoClientOptions options = MongoClientOptions.builder()
                .sslEnabled(true) //开启SSL连接
                .sslInvalidHostNameAllowed(true) //不检查证书域名
                .minConnectionsPerHost(1) //连接池最小连接数，最大连接数默认为100
                .build();
        MongoClient mongoClient =  new MongoClient(addrs, credentials, options);
        MongoDatabase testDB = mongoClient.getDatabase("liquidnet_mgdb");
        MongoCollection<Document> numbersCollection = testDB.getCollection("test");

        Document doc = new Document("name", "pi").append("value", 3.14159);
        numbersCollection.insertOne(doc);

        MongoCursor<Document> cursor = numbersCollection.find().iterator();
        try {
            while (cursor.hasNext()) {
                System.out.println(cursor.next().toJson());
            }
        } finally {
            cursor.close();
        }
    }
}
