package com.liquidnet.service.adam.service;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import org.checkerframework.checker.units.qual.A;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description:
 * @class: RedisTest
 * @Package com.liquidnet.service.adam.service
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/11/24 5:54 下午
 */
@SpringBootTest
@RunWith(SpringRunner.class)
public class RedisTest {
    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;


    @Test
    public void test() {
        String str = "wozuiyangqi";
        String key = "Redis16_test";
        String hashkey = "" + str;
        Map<String,String> map = new HashMap<String,String>();
        map.put("nihao", "nihao");
        map.put("wohao", "wohao");
        map.put("dajiahao", "dajiahao");
        map.put("caishi", "caishi");
        map.put("zhengdehao", "zhengdehao");
        map.put("formwozuiyangqi", "formwozuiyangqi");
        System.out.println(map);
        redisTemplate.opsForHash().put(key, hashkey, map);
        redisTemplate.opsForHash().put(key, "22222", map);
        redisTemplate.opsForHash().put(key, "22222", "map");
//        redisTemplate.opsForHash().put(key, "22222", "test");

        System.out.println(redisTemplate.opsForHash().keys(key));

//        redisTemplate.opsForHash().put("adam:user:login:token:1331542635751596034", "33333", map);
//        redisTemplate.opsForValue().set("adam:user:login:token:1331542635751596034", "33333");
//        System.out.println(redisTemplate.opsForValue().get("adam:user:login:token:1331542635751596034"));
        redisTemplate.expire(key, 100000, TimeUnit.SECONDS);
    }

    @Test
    public void testNew() {
        String str = "wozuiyangqi";
        String key = "Redis16_test";
        Map<String,String> map = new HashMap<String,String>();
        map.put("nihao", "nihao");
        map.put("wohao", "wohao");
        map.put("dajiahao", "dajiahao");
        map.put("caishi", "caishi");
        map.put("zhengdehao", "zhengdehao");
        map.put("formwozuiyangqi", "formwozuiyangqi");
        redisTemplate.opsForValue().set(key, map.toString());
        redisTemplate.opsForValue().set(key,map.toString(),10l,TimeUnit.SECONDS);
    }
//    public static void main(String[] args) {
//        RedisTest test = new RedisTest();
//        test.test("wozuiyangqi");
//        test.testNew("wozuiyangqi");
//    }
}
