package com.liquidnet.service.adam.service.impl;
import com.alibaba.fastjson.JSON;
import com.liquidnet.service.adam.entity.AdamAccount;
import com.liquidnet.service.adam.service.IAdamAccountService;
import com.liquidnet.service.adam.service.IAdamAccountWalletService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import javax.sound.midi.Soundbank;
import java.time.LocalDateTime;

/**
 * @author Li Chen
 * @date 2020-10-21 19:16
 */
@SpringBootTest
@RunWith(SpringRunner.class)
public class AdamAccountServiceImplTest {

    @Autowired
    IAdamAccountService adamAccountService;

    @Autowired
    IAdamAccountWalletService adamAccountWalletService;

    @Test
    public void insert() {
        AdamAccount updateAdamAccount = new AdamAccount();
        updateAdamAccount.setId("114434");
        updateAdamAccount.setComId("333");
        LocalDateTime now = LocalDateTime.now();
        System.out.println(now);
        updateAdamAccount.setCreateTime(now);
        adamAccountService.insert(updateAdamAccount);

    }

    @Test
    public void selectById() {
        AdamAccount account = adamAccountService.selectById("114434");
        System.out.println(JSON.toJSONString(account));

    }



    @Test
    public void updateById() {
        AdamAccount updateAdamAccount = new AdamAccount();
        updateAdamAccount.setId("1318872013997334529");
        updateAdamAccount.setFinId("7");
        adamAccountService.updateById(updateAdamAccount);

    }

}