package com.liquidnet.service.adam.service.impl;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DESUtils;
import com.liquidnet.service.adam.common.EmailEntity;
import com.liquidnet.service.adam.dto.AdamUserSignUpParam;
import com.liquidnet.service.adam.dto.base.AdamResultDto;
import com.liquidnet.service.adam.entity.AdamUser;
import com.liquidnet.service.adam.mapper.AdamUserMapper;
import com.liquidnet.service.adam.service.IAdamUserService;
import com.liquidnet.service.adam.util.EmailUtil;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.UUID;
import java.util.concurrent.TimeUnit;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

@Slf4j
@SpringBootTest
@RunWith(SpringRunner.class)
public class AdamUserServiceImplTest {

    @Autowired
    private IAdamUserService adamUserService;

    @Autowired
    private AdamUserMapper adamUserMapper;

    @Autowired
    private EmailUtil emailUtil;

    @Autowired
    private RedisUtil redisUtil;


    @Value("${spring.profiles.active}")
    private String springProfilesActive;

    @Test
    public void saveComAndUserInfo() {
        AdamUserSignUpParam userSignUpParams = new AdamUserSignUpParam("Tom", "Nicolass", "worker",
                "11111", "aaaaa@qq.com", "123456ab", "a", "b");
        try {
            AdamResultDto dto = adamUserService.userSignUp(userSignUpParams);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    // @Test
    public void sendConfirmEmail() throws Exception {
        String confirmTag = UUID.randomUUID().toString();
        DESUtils desUtils = new DESUtils("desKey");
        AdamUser adamUser = new AdamUser();
        adamUser.setEmail("992072389@qq.com");
        adamUser.setId("1");
        String encrypt = desUtils.encrypt(adamUser.getId() + "_" + confirmTag);
        emailUtil.doSendMsg(buildEmail(adamUser, encrypt));
    }

    private EmailEntity buildEmail(AdamUser adamUser, String confirmLinkParam) {
        EmailEntity emailEntity = new EmailEntity();
        emailEntity.setFromPerson("Liquid Net");
        emailEntity.setToPerson(adamUser.getEmail());
        emailEntity.setTargetMail(adamUser.getEmail());
        emailEntity.setContent("Please click the link below in order to complete sign up " +
                "</br> http://192.168.31.229/service-adam/adam-user/user-confirm-email/" + confirmLinkParam);
        return emailEntity;
    }

    @Test
    public void saveAndGetUserToken() {

        String userId = "test123";
        String token = "token_123";

        redisUtil.hset("user_token", token, userId, TimeUnit.SECONDS.toSeconds(30));
    }



}
