package com.liquidnet.commons.lang.util;

import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

public class CurrentUtil {
    public static final String CK_ENV_ACTIVE = "spring.profiles.active";
    public static final String GRAY_LOGIN_SMS_CODE = "111111";

    /* ======================================================= | */

    public static final String uID = "sub";
    public static final String uTag = "u-tag";
    public static final String uToken = "authorization";

    public static final String CLI_SOURCE = "source";
    public static final String CLI_VERSION = "version";
    public static final String CLI_UNKNOWN = "unknown";

    private static final String IP_UTILS_FLAG = ",";
    private static final String LOCALHOST_IP = "0:0:0:0:0:0:0:1";
    private static final String LOCALHOST_IP1 = "127.0.0.1";

    public static String getToken() {
        return StringUtils.defaultIfEmpty((String) ServletUtils.getRequest().getAttribute(uToken), "");
    }

    public static Map getTokenClaims() {
        return JsonUtils.fromJson((String) ServletUtils.getRequest().getAttribute(CurrentUtil.uTag), Map.class);
    }

    public static String getCurrentUid() {
        return (String) ServletUtils.getRequest().getAttribute(uID);
    }

    public static String getCliSource() {
        return ServletUtils.getRequest().getHeader(CLI_SOURCE);
    }

    public static String getCliVersion() {
        return ServletUtils.getRequest().getHeader(CLI_VERSION);
    }

    public static String getCliIpAddr() {
        HttpServletRequest request = ServletUtils.getRequest();
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || CLI_UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || CLI_UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (ip == null || ip.length() == 0 || CLI_UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || CLI_UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || CLI_UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
//            if (LOCALHOST_IP1.equalsIgnoreCase(ip) || LOCALHOST_IP.equalsIgnoreCase(ip)) {
//                // 根据网卡取本机配置的IP
//                InetAddress iNet = null;
//                try {
//                    iNet = InetAddress.getLocalHost();
//                } catch (UnknownHostException e) {
//                    e.printStackTrace();
//                }
//                ip = iNet.getHostAddress();
//            }
        }
        // 使用代理，则获取第一个IP地址
        if (!StringUtils.isEmpty(ip) && ip.indexOf(IP_UTILS_FLAG) > 0) {
            ip = ip.substring(0, ip.indexOf(IP_UTILS_FLAG));
        }
        return LOCALHOST_IP.equals(ip) ? LOCALHOST_IP1 : ip;
    }
}
