package com.liquidnet.common.third.antchain.biz;

import com.liquidnet.common.third.antchain.config.AntchainConfig;
import com.liquidnet.commons.lang.util.BeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.NameValuePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.beans.IntrospectionException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxlnftBiz
 * @Package com.liquidnet.common.third.antchain
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/21 11:19
 */
@Slf4j
@Component
public class AntchainBiz {
    @Autowired
    private AntchainConfig antchainConfig;

    /**
     * 构造GET请求url
     * @param requestUrl
     * @param tClass
     * @param <T>
     * @return
     */
    public <T> String buildGetRequestUrl(String requestUrl,Class<T> tClass,Object obj){
        //拼接请求url
        URI build = null;
//        String reqUrl = null;
//        try {
//            UriComponentsBuilder builder = UriComponentsBuilder
//                    .fromHttpUrl(requestUrl).queryParams(this.buildGetReqParams(obj));
//            reqUrl =  builder.build(true).toString();
//        }
//        catch (Exception e) {
//            e.printStackTrace();
//        }

        List<NameValuePair> params = BeanUtil.convertBeanToNameValuePairList(obj);
        requestUrl = requestUrl.concat("?");
        for(NameValuePair nameValuePair:params){
            try {
                requestUrl = requestUrl.concat("&"+nameValuePair.getName()+"="+ URLEncoder.encode(nameValuePair.getValue().toString(), "UTF-8"));
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
//        try {
//            build = new URIBuilder(requestUrl).addParameters(params).build();
//        } catch (URISyntaxException e) {
//            e.printStackTrace();
//        }

//        if(build.toString().contains("%20")){
//            return build.toString().replaceAll("%20","+");
//        }
        return requestUrl;
    }

    public MultiValueMap<String, String> buildGetReqParams(Object obj){
        Map<String,Object> map = null;
        try {
            map = BeanUtil.convertBeanToMap(obj,false);
        } catch (IntrospectionException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }

        MultiValueMap<String, String>  params = new LinkedMultiValueMap();
        // Map集合循环遍历方式三 推荐，尤其是容量大时
        for (Map.Entry<String, Object> m : map.entrySet()) {
            params.add(m.getKey(),m.getValue().toString());
        }
        return params;

    }
}
