package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 观演人修改记录表
 * </p>
 *
 * @author jiangxiulong
 * @since 2024-06-19
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinOrderTicketEntitiesEditLog implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * entities_edit_log_id
     */
    private String entitiesEditLogId;

    /**
     * order_ticket_entities_id
     */
    private String orderTicketEntitiesId;

    /**
     * 操作人ID
     */
    private Long sysUserId;

    /**
     * 操作人昵称
     */
    private String sysUserName;

    /**
     * 旧 入场人证件类型
     */
    private Integer enterTypeOld;

    /**
     * 旧 入场人姓名
     */
    private String enterNameOld;

    /**
     * 旧 入场人证件号
     */
    private String enterIdCodeOld;

    /**
     * 入场人证件类型 1大陆身份证 2港澳通行证 3台胞证 4护照 5军官证
     */
    private Integer enterType;

    /**
     * 入场人姓名
     */
    private String enterName;

    /**
     * 入场人证件号
     */
    private String enterIdCode;

    /**
     * 备注原因
     */
    private String remark;

    /**
     * 凭证图片
     */
    private String images;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final KylinOrderTicketEntitiesEditLog obj = new KylinOrderTicketEntitiesEditLog();

    public static KylinOrderTicketEntitiesEditLog getNew() {
        try {
            return (KylinOrderTicketEntitiesEditLog) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinOrderTicketEntitiesEditLog();
        }
    }

}
