package com.liquidnet.service.goblin.service.manage;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.manage.GoblinStorePurchaseItemParam;
import com.liquidnet.service.goblin.dto.vo.GoblinPurchasingVo;

import java.util.List;

public interface IGoblinStorePurchasingService {

    /**
     * 活动列表
     *
     * @param page         页数
     * @param purchaseName 活动名称
     * @param status       状态
     * @param st           开始时间
     * @param et           结束时间
     * @param ct           创建时间
     * @return
     */
    ResponseDto<List<GoblinPurchasingVo>> purchasingList(int page, String purchaseName, int status, String st, String et, String ct);

    /**
     * 活动状态操作
     *
     * @param marketId 活动秒杀id
     * @param status   状态
     * @return
     */
    ResponseDto<Boolean> purchasingStatus(String marketId, int status);

    /**
     * 添加 显示秒杀活动
     *
     * @param purchaseName 秒杀活动名称
     * @param storeId      商铺id
     * @param st           开始时间
     * @param et           结束时间
     * @param isPre        是否预热
     * @param preTime      预热时间
     * @return
     */
    ResponseDto<Boolean> purchasingInsert(String purchaseName, String storeId, String st, String et, Integer isPre, String preTime);

    /**
     * @param marketId     活动id
     * @param purchaseName 秒杀活动名称
     * @param storeId      商铺id
     * @param st           开始时间
     * @param et           结束时间
     * @param isPre        是否预热
     * @param preTime      预热时间
     * @return
     */
    ResponseDto<Boolean> purchasingUpdate(String marketId, String purchaseName, String storeId, String st, String et, Integer isPre, String preTime);

    /**
     * 获取 限时秒杀 详情
     *
     * @param marketId 活动秒杀id
     * @return
     */
    ResponseDto<GoblinPurchasingVo> purchasingDetails(String marketId);

    /**
     * 获取活动内sku列表
     *
     * @param marketId 活动秒杀id
     * @param page     页数
     * @return
     */
    ResponseDto<String> purchasingSkuList(String marketId, int page);//TODO 返回值

    /**
     * 配置活动相关sku
     *
     * @param params
     * @return
     */
    ResponseDto<Boolean> purchasingSkuOperation(List<GoblinStorePurchaseItemParam> params);

    /**
     * 删除活动内sku
     *
     * @param marketId 活动秒杀id
     * @param skuId    skuId
     * @return
     */
    ResponseDto<Boolean> purchasingSkuDel(String marketId, String skuId);
}
