package com.liquidnet.service.chime.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

@ApiModel(value = "ChimeTagVo", description = "标签库")
public class ChimeTagVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 5852327873275898342L;
    @ApiModelProperty(position = 11, value = "标签Key")
    private String val;
    @ApiModelProperty(position = 12, value = "标签名称")
    private String desc;

    private static final ChimeTagVo obj = new ChimeTagVo();

    public static ChimeTagVo getNew() {
        try {
            return (ChimeTagVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new ChimeTagVo();
    }

    public String getVal() {
        return val;
    }

    public ChimeTagVo setVal(String val) {
        this.val = val;
        return this;
    }

    public String getDesc() {
        return desc;
    }

    public ChimeTagVo setDesc(String desc) {
        this.desc = desc;
        return this;
    }
}
