package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class ExpressBatches implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 管理员
     */
    private Integer adminId;

    /**
     * 订单Id，订阅前查询
     */
    private Integer orderId;

    /**
     * 订单类型 order_product 商品订单 , order_ticket 票务订单, order_integration 积分订单
     */
    private String orderType;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 快递公司名称
     */
    private String name;

    /**
     * 快递公司编号
     */
    private String company;

    /**
     * 快递单号
     */
    private String number;

    /**
     * 状态 0新导入 1订阅成功 2订阅失败
     */
    private Integer status;

    /**
     * 导入时间
     */
    private LocalDateTime importTime;

    /**
     * 导入批次
     */
    private Integer batch;

    /**
     * 失败原因
     */
    private String reason;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;


}
