package com.liquidnet.service.galaxy.router.xuper.biz;

import com.liquidnet.common.exception.constant.ErrorCode;
import com.liquidnet.common.third.xuper.config.XuperConfig;
import com.liquidnet.common.third.xuper.dto.*;
import com.liquidnet.common.third.xuper.exception.XupterException;
import com.liquidnet.common.third.xuper.util.XuperSdkUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.biz.GalaxyEnumBiz;
import com.liquidnet.service.galaxy.constant.GalaxyErrorEnum;
import com.liquidnet.service.galaxy.dto.TradeInfoDto;
import com.liquidnet.service.galaxy.dto.bo.GalaxyNftOrderBo;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesNftInfoBo;
import com.liquidnet.service.galaxy.dto.param.*;
import com.liquidnet.service.galaxy.router.strategy.IGalaxyRouterStrategyTradeQuery;
import com.liquidnet.service.galaxy.utils.GalaxyDataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: XuperTradeQueryBiz
 * @Package com.liquidnet.service.galaxy.router.xuper.biz
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/6/27 11:11
 */
@Slf4j
@Component
public class XuperTradeQueryBiz implements IGalaxyRouterStrategyTradeQuery {
    @Autowired
    private XuperSdkUtil xuperSdkUtil;
    @Autowired
    private XuperConfig xuperConfig;
    @Autowired
    private GalaxyDataUtils dataUtils;

    public ResponseDto<GalaxyQueryNftInfoRespDto> queryNftInfo(GalaxyQueryNftInfoReqDto reqDto) {
        //获取订单信息
        GalaxyNftOrderBo nftOrderBo = dataUtils.getNftOrderBo(reqDto.getRouterType(),reqDto.getNftOrderPayId());
        if(StringUtil.isNull(nftOrderBo)){
            return ResponseDto.failure(GalaxyErrorEnum.NFT_QUERY_FAIL_ORDER_NOT_EXIST.getCode(),GalaxyErrorEnum.NFT_QUERY_FAIL_ORDER_NOT_EXIST.getMessage());
        }
        if(StringUtil.isEmpty(nftOrderBo.getNftId())){
            return ResponseDto.failure(GalaxyErrorEnum.NFT_QUERY_FAIL_NFT_NOT_EXIST.getCode(),GalaxyErrorEnum.NFT_QUERY_FAIL_NFT_NOT_EXIST.getMessage());
        }

        //获取sku信息
        GalaxySeriesNftInfoBo seriesNftInfoBo = dataUtils.getSeriesNftInfoBo(reqDto.getRouterType(),nftOrderBo.getSkuId());
        if(StringUtil.isNull(seriesNftInfoBo)){
            return ResponseDto.failure(GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getCode(), GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getMessage());
        }

        //执行资产碎片授予查询
        Xuper010QuerySdsReqDto xuper010QuerySdsReqDto = Xuper010QuerySdsReqDto.getNew();
        // 定义返回结果对象
        Xuper010QuerySdsRespDto xuper010QuerySdsRespDto = null;
        long shardId = 1l;
        try {
            xuper010QuerySdsReqDto.setAssetId(Long.parseLong(nftOrderBo.getSeriesId()));
            xuper010QuerySdsReqDto.setShardId(shardId);
            XuperResponseDto<Xuper010QuerySdsRespDto>  xuperResponseDto = xuperSdkUtil.xuper010QuerySds(xuper010QuerySdsReqDto);
            if(xuperResponseDto.isSuccess()){
                xuper010QuerySdsRespDto = xuperResponseDto.getParseData(Xuper010QuerySdsRespDto.class);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("xuper010QuerySds resp : "+ JsonUtils.toJson(xuper010QuerySdsRespDto));

        if(String.valueOf(xuper010QuerySdsRespDto.getErrNo()).equalsIgnoreCase(ErrorCode.SUCCESS.getCode())){
            Xuper010QuerySdsRespDto.ShardMeta shardMeta = xuper010QuerySdsRespDto.getMeta();
            Xuper010QuerySdsRespDto.ShardAssetInfo assetInfo = shardMeta.getAssetInfo();
            //返回结果
            GalaxyQueryNftInfoRespDto respDto = GalaxyQueryNftInfoRespDto.getNew();
            respDto.setNftId(String.valueOf(shardMeta.getAssetId()));
            respDto.setOwnerAddr(shardMeta.getOwnerAddr());
            respDto.setAuthor(assetInfo.getCreateAddr());
            respDto.setName(assetInfo.getTitle());
            respDto.setUrl(seriesNftInfoBo.getNftUrl());
            respDto.setDisplayUrl(seriesNftInfoBo.getDisplayUrl());
            respDto.setHash(seriesNftInfoBo.getNftHash());
            respDto.setOwnerGainedTime(shardMeta.getCtime());
            respDto.setDesc(assetInfo.getShortDesc());
            respDto.setFlag("");
            respDto.setSeriesName(seriesNftInfoBo.getSeriesName());
            respDto.setSeriesId(String.valueOf(shardMeta.getAssetId()));
            respDto.setSeriesTotalNum(seriesNftInfoBo.getNftTotalCount());
            respDto.setMetaData("");
            respDto.setPublisherAddr(assetInfo.getCreateAddr());
            respDto.setPublishPlatformAddr(assetInfo.getCreateAddr());
            respDto.setSeriesIndexId(Long.valueOf(shardMeta.getShardId()).intValue());
            respDto.setPublishTxHash(shardMeta.getTxId());
            respDto.setSellStatus(1);
            respDto.setSellCount(shardMeta.getPrice());

//            GalaxyNftBuyResultQueryRespDto resultQueryRespDto = GalaxyNftBuyResultQueryRespDto.getNew();
//            String nowTimeStr = DateUtil.getNowTime();
//            //转换任务状态
//            Integer taskStatus = Integer.valueOf(GalaxyEnumBiz.getGrantStatusEnum(reqDto.getRouterType(),String.valueOf(xuper010QuerySdsRespDto.getMeta().getStatus())).getCode());
//            resultQueryRespDto.setTaskStatus(taskStatus);
//            resultQueryRespDto.setChainTimestamp(nowTimeStr);
//            resultQueryRespDto.setPayTaskId(xuper010QuerySdsRespDto.getMeta().getTxId());
//            resultQueryRespDto.setTxHash(xuper010QuerySdsRespDto.getMeta().getTxId());
            return ResponseDto.success(respDto);
        }else{
            return ResponseDto.failure(GalaxyErrorEnum.NFT_PUBLISH_AND_BUY_QUERY_FAIL.getCode(),GalaxyErrorEnum.NFT_PUBLISH_AND_BUY_QUERY_FAIL.getMessage());
        }
    }

    public ResponseDto<GalaxyQueryTransNftInfoRespDto> queryTransNftInfo(GalaxyQueryTransNftInfoReqDto reqDto) {
        if(StringUtil.isEmpty(reqDto.getNftId())){
            return ResponseDto.failure(GalaxyErrorEnum.NFT_QUERY_FAIL_NFT_NOT_EXIST.getCode(),GalaxyErrorEnum.NFT_QUERY_FAIL_NFT_NOT_EXIST.getMessage());
        }

        //执行资产碎片授予查询
        Xuper010QuerySdsReqDto xuper010QuerySdsReqDto = Xuper010QuerySdsReqDto.getNew();
        // 定义返回结果对象
        Xuper010QuerySdsRespDto xuper010QuerySdsRespDto = null;
        try {
            //资产id
            Long assetId = null;
            //碎片id
            Long shardId = null;
            String nftId = reqDto.getNftId();

            if(StringUtil.isNotEmpty(nftId)){
                assetId = Long.parseLong(nftId.substring(0,nftId.lastIndexOf("_")));
                shardId = Long.parseLong(nftId.substring(nftId.lastIndexOf("_")+1,nftId.length()));
            }

            xuper010QuerySdsReqDto.setAssetId(assetId);
            xuper010QuerySdsReqDto.setShardId(shardId);
            XuperResponseDto<Xuper010QuerySdsRespDto>  xuperResponseDto = xuperSdkUtil.xuper010QuerySds(xuper010QuerySdsReqDto);
            if(xuperResponseDto.isSuccess()){
                xuper010QuerySdsRespDto = xuperResponseDto.getParseData(Xuper010QuerySdsRespDto.class);
            }else{
                return ResponseDto.failure(GalaxyErrorEnum.NFT_TRANSFER_QUERY_ERROR.getCode(),GalaxyErrorEnum.NFT_TRANSFER_QUERY_ERROR.getMessage()+"nftId:"+nftId);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("xuper010QuerySds resp : "+ JsonUtils.toJson(xuper010QuerySdsRespDto));

        if(String.valueOf(xuper010QuerySdsRespDto.getErrNo()).equalsIgnoreCase(ErrorCode.SUCCESS.getCode())){
            Xuper010QuerySdsRespDto.ShardMeta shardMeta = xuper010QuerySdsRespDto.getMeta();
            Xuper010QuerySdsRespDto.ShardAssetInfo assetInfo = shardMeta.getAssetInfo();
            //返回结果
            GalaxyQueryTransNftInfoRespDto respDto = GalaxyQueryTransNftInfoRespDto.getNew();
            respDto.setNftId(shardMeta.getAssetId()+"_"+shardMeta.getShardId());
            respDto.setOwnerAddr(shardMeta.getOwnerAddr());
            respDto.setPublishAddr(assetInfo.getCreateAddr());
            respDto.setName(assetInfo.getTitle());
            respDto.setDesc(assetInfo.getShortDesc());
            if(assetInfo.getThumb()[0]!=null&&assetInfo.getThumb()[0].getUrls().getUrl3()!=null){
                respDto.setUrl(assetInfo.getThumb()[0].getUrls().getUrl3());
                respDto.setDisplayUrl(assetInfo.getThumb()[0].getUrls().getUrl3());
            }
            //获取交易时间
            LocalDateTime transTime = DateUtil.ofEpochMilli(shardMeta.getCtime());
            respDto.setTradeTime(DateUtil.format(transTime, DateUtil.Formatter.yyyyMMddHHmmss));
            respDto.setTradeHash(shardMeta.getTxId());
            respDto.setTradeStatus(GalaxyEnumBiz.getTransStatusEnum(reqDto.getRouterType(),String.valueOf(shardMeta.getStatus())).getCode());

            return ResponseDto.success(respDto);
        }else{
            return ResponseDto.failure(GalaxyErrorEnum.NFT_TRANSFER_QUERY_ERROR.getCode(),GalaxyErrorEnum.NFT_TRANSFER_QUERY_ERROR.getMessage());
        }
    }

    public ResponseDto<GalaxyQueryNftTradeListRespDto> queryNftTradeList(GalaxyQueryNftTradeListReqDto reqDto) {
//        //获取订单信息
//        GalaxyTransferNftInfoBo transferNftInfoBo = dataUtils.getGalaxyTransferNftInfoBo(reqDto.getRouterType(),reqDto.getNftOrderPayId());
//
//        if(StringUtil.isNull(transferNftInfoBo)){
//            return ResponseDto.failure(GalaxyErrorEnum.NFT_QUERY_FAIL_ORDER_NOT_EXIST.getCode(),GalaxyErrorEnum.NFT_QUERY_FAIL_ORDER_NOT_EXIST.getMessage());
//        }
//        if(StringUtil.isEmpty(transferNftInfoBo.getNftId())){
//            return ResponseDto.failure(GalaxyErrorEnum.NFT_QUERY_FAIL_NFT_NOT_EXIST.getCode(),GalaxyErrorEnum.NFT_QUERY_FAIL_NFT_NOT_EXIST.getMessage());
//        }

        Xuper013HistoryReqDto xuper013HistoryReqDto = Xuper013HistoryReqDto.getNew();
        // 定义返回结果对象
        Xuper013HistoryRespDto respDto = null;
        try {
            //资产id
            Long assetId = null;
            //碎片id
            Long shardId = null;
            String nftId = reqDto.getNftId();

            if(StringUtil.isNotEmpty(nftId)){
                assetId = Long.parseLong(nftId.substring(0,nftId.lastIndexOf("_")));
                shardId = Long.parseLong(nftId.substring(nftId.lastIndexOf("_")+1,nftId.length()));
            }
            xuper013HistoryReqDto.setAssetId(assetId);
            xuper013HistoryReqDto.setShardId(shardId);
            xuper013HistoryReqDto.setPage(1);
            xuper013HistoryReqDto.setLimit(50);
            XuperResponseDto<Xuper013HistoryRespDto>  xuperResponseDto = xuperSdkUtil.xuper013History(xuper013HistoryReqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper013HistoryRespDto.class);

                GalaxyQueryNftTradeListRespDto nftTradeListRespDto =GalaxyQueryNftTradeListRespDto.getNew();
                if(respDto.getList().size()>0){
                    List<GalaxyQueryNftTradeListRespDto.TransInfoDto> tradeList = new ArrayList<>();
                    nftTradeListRespDto.setTransList(tradeList);
                    nftTradeListRespDto.setTotal(Long.parseLong(String.valueOf(respDto.getList().size())));
                    for(Xuper013HistoryRespDto.History history:respDto.getList()){
                        GalaxyQueryNftTradeListRespDto.TransInfoDto transInfoDto = GalaxyQueryNftTradeListRespDto.TransInfoDto.getNew();
                        transInfoDto.setFromAddr(history.getFrom());
                        transInfoDto.setToAddr(history.getTo());
                        transInfoDto.setTxType(Integer.parseInt(String.valueOf(history.getType())));
                        transInfoDto.setTxHash(history.getTxId());
                        LocalDateTime tradeTime = DateUtil.ofEpochMilli(history.getCtime());
                        transInfoDto.setDealTimestamp(history.getCtime());
                        transInfoDto.setDealTimestampStr(DateUtil.format(tradeTime, DateUtil.Formatter.yyyyMMddHHmmss));
                        nftTradeListRespDto.getTransList().add(transInfoDto);
                    }
                }else{
                    nftTradeListRespDto.setTransList(null);
                    nftTradeListRespDto.setTotal(Long.parseLong(String.valueOf(respDto.getList().size())));
                }
                return ResponseDto.success(nftTradeListRespDto);
            }else{
                return ResponseDto.failure(GalaxyErrorEnum.NFT_QUERY_FAIL_NFT_NOT_EXIST.getCode(),GalaxyErrorEnum.NFT_QUERY_FAIL_NFT_NOT_EXIST.getMessage()+"nftId:"+nftId);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuper013History resp : "+ JsonUtils.toJson(respDto));
        return ResponseDto.failure();
    }

    public ResponseDto<GalaxyQuerySeriesInfoRespDto> querySeriesInfo(GalaxyQuerySeriesInfoReqDto reqDto) {
        //获取sku信息
        GalaxySeriesNftInfoBo seriesNftInfoBo = dataUtils.getSeriesNftInfoBo(reqDto.getRouterType(),reqDto.getSkuId());
        if(StringUtil.isNull(seriesNftInfoBo)){
            return ResponseDto.failure(GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getCode(), GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getMessage());
        }

        Xuper005QueryAssetReqDto xuper005QueryAssetReqDto = Xuper005QueryAssetReqDto.getNew();
        // 定义返回结果对象
        Xuper005QueryAssetRespDto respDto = null;
        //百度超级链使用的是资产id作为任务id
        long assetId = Long.parseLong(seriesNftInfoBo.getSeriesId());
        try {
            xuper005QueryAssetReqDto.setAssetId(assetId);
            XuperResponseDto<Xuper005QueryAssetRespDto> xuperResponseDto = xuperSdkUtil.xuper005QueryAsset(xuper005QueryAssetReqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper005QueryAssetRespDto.class);
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("seriesClaimResultQuery resp : "+ JsonUtils.toJson(respDto));
        if(respDto.getErrNo() == Integer.parseInt(ErrorCode.SUCCESS.getCode())){
            Xuper005QueryAssetRespDto.AssetMeta meta = respDto.getMeta();
            //查询结果
            GalaxyQuerySeriesInfoRespDto querySeriesInfoRespDto = GalaxyQuerySeriesInfoRespDto.getNew();
            querySeriesInfoRespDto.setName(meta.getTitle());
            querySeriesInfoRespDto.setSeriesId(String.valueOf(meta.getAssetId()));
            querySeriesInfoRespDto.setCreatorAddr(meta.getCreateAddr());
            querySeriesInfoRespDto.setCoverUrl(meta.getImgDesc().get(0).toString());
            querySeriesInfoRespDto.setNftUrl(meta.getAssetUrl().get(0).toString());
            querySeriesInfoRespDto.setNftThumbIcon(meta.getThumb()[0].getUrls().getIcon());
            querySeriesInfoRespDto.setNftThumbUrl1(meta.getThumb()[0].getUrls().getUrl1());
            querySeriesInfoRespDto.setNftThumbUrl2(meta.getThumb()[0].getUrls().getUrl2());
            querySeriesInfoRespDto.setNftThumbUrl3(meta.getThumb()[0].getUrls().getUrl3());

            querySeriesInfoRespDto.setDesc(meta.getShortDesc());
            querySeriesInfoRespDto.setTotalCount(String.valueOf(meta.getAmount()));
            querySeriesInfoRespDto.setSeriesBeginFromZero(Boolean.FALSE.toString());
            querySeriesInfoRespDto.setCrtCount("-");
            querySeriesInfoRespDto.setCreateTimeStamp(DateUtil.format(seriesNftInfoBo.getCreatedAt(), DateUtil.Formatter.yyyyMMddHHmmss));
            return ResponseDto.success(querySeriesInfoRespDto);
        }
        return ResponseDto.failure();
    }

    public ResponseDto<GalaxyQueryUserSeriesNftListRespDto> queryUserSeriesNftList(GalaxyQueryUserSeriesNftListReqDto reqDto) {
//        //获取用户信息
//        GalaxyUserInfoBo userInfoBo = dataUtils.getGalaxyUserInfo(reqDto.getRouterType(),reqDto.getUserId());
//
//        //获取sku信息
//        GalaxySeriesNftInfoBo seriesNftInfoBo = dataUtils.getSeriesNftInfoBo(reqDto.getRouterType(),reqDto.getSkuId());
//        if(StringUtil.isNull(seriesNftInfoBo)){
//            return ResponseDto.failure(GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getCode(), GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getMessage());
//        }
//
//        Nft037AddressListReqDto nft037ReqDto = Nft037AddressListReqDto.getNew();
//        nft037ReqDto.setAddr(userInfoBo.getBlockChainAddress());
//        nft037ReqDto.setSeriesId(seriesNftInfoBo.getSeriesId());
//        nft037ReqDto.setLimit(1000l);
//        ZxlnftResponseDto<Nft037AddressListRespDto> zxlnftResponseDto = zxlnftSdkUtil.nft037AddressList(nft037ReqDto);
//
//
//        GalaxyQueryUserSeriesNftListRespDto queryNftListRespDto = GalaxyQueryUserSeriesNftListRespDto.getNew();
//        if(zxlnftResponseDto.isSuccess()){
//            BeanUtil.copy(zxlnftResponseDto.getData(),queryNftListRespDto);
//            queryNftListRespDto.setUserId(reqDto.getUserId());
//            queryNftListRespDto.setSeriesId(seriesNftInfoBo.getSeriesId());
//        }else{
//            return ResponseDto.failure();
//        }
//        return ResponseDto.success(queryNftListRespDto);
        return ResponseDto.failure();
    }

    public ResponseDto<GalaxyQueryUserTradeAllListRespDto> queryUserTradeAllList(GalaxyQueryUserTradeAllListReqDto reqDto) {
        //要查询的区块链账户地址
        String addr = reqDto.getBlockChainAddress();
        Xuper011ListSdsByAddrReqDto xuper011ListSdsByAddrReqDto = Xuper011ListSdsByAddrReqDto.getNew();
        // 定义返回结果对象
        Xuper011ListSdsByAddrRespDto respDto = null;
        try {
            //资产id
            Long assetId = Long.parseLong(reqDto.getSeriesId());

            xuper011ListSdsByAddrReqDto.setAddr(addr);
            xuper011ListSdsByAddrReqDto.setPage(1);
            xuper011ListSdsByAddrReqDto.setLimit(50);
            xuper011ListSdsByAddrReqDto.setAssetId(assetId);

            XuperResponseDto<Xuper011ListSdsByAddrRespDto> xuperResponseDto = xuperSdkUtil.xuper011ListSdsByAddr(xuper011ListSdsByAddrReqDto);
            if(xuperResponseDto.isSuccess()){
                respDto = xuperResponseDto.getParseData(Xuper011ListSdsByAddrRespDto.class);

                GalaxyQueryUserTradeAllListRespDto tradeAllListRespDto = GalaxyQueryUserTradeAllListRespDto.getNew();
                if(respDto.getList().size()>0){
                    List<TradeInfoDto> tradeList = new ArrayList<>();
                    tradeAllListRespDto.setTradeList(tradeList);
                    tradeAllListRespDto.setTotal(Long.parseLong(String.valueOf(respDto.getList().size())));
                    for(Xuper011ListSdsByAddrRespDto.ShardMeta shardMeta:respDto.getList()){
                        TradeInfoDto tradeInfoDto = TradeInfoDto.getNew();
                        tradeInfoDto.setNftId(shardMeta.getAssetId()+"_"+shardMeta.getShardId());
                        tradeInfoDto.setToAddr(shardMeta.getOwnerAddr());
                        tradeInfoDto.setHash(shardMeta.getTxId());
                        tradeAllListRespDto.getTradeList().add(tradeInfoDto);
                    }
                }else{
                    tradeAllListRespDto.setTradeList(null);
                    tradeAllListRespDto.setTotal(Long.parseLong(String.valueOf(respDto.getList().size())));
                }
                return ResponseDto.success(tradeAllListRespDto);
            }else{
                return ResponseDto.failure(GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getCode(), GalaxyErrorEnum.SERIES_NFT_INFO_NOT_EXIST.getMessage());
            }
        }catch (XupterException e) {
            log.error("biz error msg "+e.getMessage(),e);
        }catch (Exception e) {
            log.error("sys error msg "+e.getMessage(),e);
        }
        log.info("testXuper011ListSdsByAddr resp : "+ JsonUtils.toJson(respDto));
        return ResponseDto.failure();
    }

    public ResponseDto<GalaxyQueryUserTradeInListRespDto> queryUserTradeInList(GalaxyQueryUserTradeInListReqDto reqDto) {
//        Nft040TradeInListReqDto nft040TradeInListReqDto = Nft040TradeInListReqDto.getNew();
//        nft040TradeInListReqDto.setAddr(reqDto.getBlockChainAddress());
//        nft040TradeInListReqDto.setLimit(1000l);
//        ZxlnftResponseDto<Nft040TradeInListRespDto> zxlnftResponseDto = zxlnftSdkUtil.nft040TradeInList(nft040TradeInListReqDto);
//
//        GalaxyQueryUserTradeInListRespDto queryUserTradeInListRespDto = GalaxyQueryUserTradeInListRespDto.getNew();
//        if(zxlnftResponseDto.isSuccess()){
//            BeanUtil.copy(zxlnftResponseDto.getData(),queryUserTradeInListRespDto);
//        }else{
//            return ResponseDto.failure();
//        }
//        return ResponseDto.success(queryUserTradeInListRespDto);
        return ResponseDto.failure();
    }

    public ResponseDto<GalaxyQueryUserTradeOutListRespDto> queryUserTradeOutList(GalaxyQueryUserTradeOutListReqDto reqDto) {
//        Nft041TradeOutListReqDto nft041TradeOutListReqDto = Nft041TradeOutListReqDto.getNew();
//        nft041TradeOutListReqDto.setAddr(reqDto.getBlockChainAddress());
//        nft041TradeOutListReqDto.setLimit(1000l);
//        ZxlnftResponseDto<Nft041TradeOutListRespDto> zxlnftResponseDto = zxlnftSdkUtil.nft041TradeOutList(nft041TradeOutListReqDto);
//
//        GalaxyQueryUserTradeOutListRespDto queryUserTradeOutListRespDto = GalaxyQueryUserTradeOutListRespDto.getNew();
//        if(zxlnftResponseDto.isSuccess()){
//            BeanUtil.copy(zxlnftResponseDto.getData(),queryUserTradeOutListRespDto);
//        }else{
//            return ResponseDto.failure();
//        }
//        return ResponseDto.success(queryUserTradeOutListRespDto);
        return ResponseDto.failure();
    }
}
