package com.liquidnet.service.goblin.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "GoblinMixSearchDto", description = "Mix搜素")
@Data
public class GoblinMixSearchDto implements Serializable, Cloneable {
    private static final long serialVersionUID = 8425727558228094908L;
    @ApiModelProperty(position = 0, value = "活动id")
    private String mixId;
    @ApiModelProperty(position = 1, value = "活动名称")
    private String name;
    @ApiModelProperty(position = 5, value = "组合名称")
    private String sellName;

    private static final GoblinMixSearchDto obj = new GoblinMixSearchDto();

    public static GoblinMixSearchDto getNew() {
        try {
            return (GoblinMixSearchDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinMixSearchDto();
        }
    }
}
