package com.liquidnet.service.kylin.config;

import com.liquidnet.common.web.config.WebMvcConfig;
import com.liquidnet.service.kylin.interceptor.KylinAuthorityInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;

@Configuration
public class KylinWebMvcConfig extends WebMvcConfig {
    @Autowired
    KylinAuthorityInterceptor kylinAuthorityInterceptor;

    @Override
    protected void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(kylinAuthorityInterceptor).addPathPatterns("/**");
        super.addInterceptors(registry);
    }
}
